/* 
exploding gernade

by P34nut

*/

#include <amxmodx>
#include <engine>

#define PLUGIN_NAME "Exploding Gernade"
#define PLUGIN_VERSION "1.0"
#define PLUGIN_CREATOR "P34nut"


#define EXPLODE_DELAY 10.0

new g_ExplosionMdl, g_SmokeMdl
new bool:task[32] = false
new bool:done[32] = false

public plugin_init() {
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_CREATOR)
	register_event("ResetHUD", "rst_done", "b")
	register_event("SendAudio","grenade_throw","bc","2=%!MRAD_FIREINHOLE")
	register_event("CurWeapon", "cur_weapon", "be")
}

public plugin_precache() {
	g_ExplosionMdl = precache_model("sprites/zerogxplode.spr")
	g_SmokeMdl = precache_model("sprites/steam1.spr")
}

public plugin_modules() {
	require_module("engine")
}

public client_PreThink(id) {
	if(is_user_connected(id) && is_user_alive(id)) {
		new u_Weapon, w_Clip, w_Ammo, w_Name[32], szMessage[164]
		
		
		if((entity_get_int(id, EV_INT_button) & IN_ATTACK)) {
			// Player is in attack.. check his weapon
			u_Weapon = get_user_weapon(id, w_Clip, w_Ammo)
			
			// If the player dont have a weapon..stop!...
			if(!u_Weapon) {
				return PLUGIN_HANDLED
			}
			
			get_weaponname(u_Weapon, w_Name, 31)
			// Check if the weapon is the he grenade
			if(equal(w_Name, "weapon_hegrenade") && !done[id] && !task[id]) { 
				
				// Make a green message so you have to see it....
				format(szMessage, 163, "^x04 У вас есть 10 секунд для того что-бы бросить гранату!")
				
				message_begin(MSG_ONE,get_user_msgid("SayText"), {0,0,0}, id)
				write_byte(3)
				write_string(szMessage)
				message_end ()
		
				// make the task
				set_task(EXPLODE_DELAY, "make_explode", id)
				task[id] = true
			
			} else {
				// Player switched his weapon... remove task
				if(task_exists(id) && !task[id]) {
					remove_task(id)
				}
			}
			
		} else if(task_exists(id) && !task[id]) {
			// Player is not in attack anymore.. remove task
			remove_task(id)
		}
		
	}
	return PLUGIN_CONTINUE
}

public make_explode(id) {
	new u_Grenade, g_hs
	new uWeaponName[32]
		
	// Make the explosion
	make_explosion(id,  g_ExplosionMdl, g_SmokeMdl)
	
	// Kill the player and make a deathMSG
	user_silentkill(id)
	g_hs = random_num(0, 1)
	format(uWeaponName, 31, "grenade")
	make_deathmsg(0 , id, g_hs, uWeaponName)
	
	// Remove the grenade
	u_Grenade = get_grenade(id)
	remove_entity(u_Grenade)
		
	done[id] = true

}

public rst_done() {
	new g_plNum = get_playersnum()
	for(new i = 1; i <= g_plNum; i++) {
		if(done[i]){
			
			done[i] = false
		}
		if(task[i]) {
			task[i] = false
		}
	}
	return PLUGIN_HANDLED
}

public grenade_throw() {
	new id = read_data(1)
	if(task[id]) {
		task[id] = false
	}
}

public cur_weapon(id) {
	new w_ID, w_Clip, w_Ammo, w_Name[32]
	
	w_ID = get_user_weapon(id, w_Clip, w_Ammo)
	if(!w_ID) {
		return PLUGIN_HANDLED
	}
	get_weaponname(w_ID, w_Name, 31)
	
	if(!equal(w_Name, "weapon_hegrenade")) {
		if(task[id]) {
			task[id] = false
		}
	}
	return PLUGIN_CONTINUE
}

stock make_explosion(id,  ExplosionMdl, SmokeMdl = false, BeamCilinderMdl = false) {
	new origin[3]
	
	get_user_origin(id, origin)
	
	// Explosion
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3) // TE_EXPLOSION
	write_coord(origin[0]) // startorigin
	write_coord(origin[1])
	write_coord(origin[2] + 5)
	write_short(ExplosionMdl) // sprite
	write_byte(random_num(0,20) + 20)
	write_byte(12)
	write_byte(0)
	message_end()
	
	if(SmokeMdl) {
		// Smoke
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(5) // TE_SMOkE
		write_coord(origin[0]) // startorigin
		write_coord(origin[1])
		write_coord(origin[2] + 15)
		write_short(SmokeMdl) // sprite
		write_byte(60)
		write_byte(10)
		message_end()
	}
		
	if(BeamCilinderMdl) {
		//BeamCilinder
		message_begin( MSG_BROADCAST,SVC_TEMPENTITY,origin )
		write_byte ( 21 ) //TE_BEAMCYLINDER
		write_coord( origin[0] )
		write_coord( origin[1] )
		write_coord( origin[2] )
		write_coord( origin[0] )
		write_coord( origin[1] )
		write_coord( origin[2]+200 )
		write_short( BeamCilinderMdl )
		write_byte ( 0 )
		write_byte ( 1 )
		write_byte ( 6 )
		write_byte ( 8 )
		write_byte ( 1 )
		write_byte ( 255 )
		write_byte ( 255 )
		write_byte ( 192 )
		write_byte ( 128 )
		write_byte ( 5 )
		message_end()
	}
	return true
}