/* AMX Portal
*
* (c) Copyright 2005, KleeneX
* This file is provided as is (no warranties).
*
*/

#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <engine>

#define MAX_PORTALS	10
#define MAX_TARGETS	10
#define MAX_ALLROUNDS	10
#define MAX_BLACKHOLES	10

#define ADMIN_FLAG 	ADMIN_LEVEL_A

new mapPortals[MAX_PORTALS]
new mapTargets[MAX_TARGETS]
new mapAllrounds[MAX_ALLROUNDS]
new mapBlackholes[MAX_BLACKHOLES]

new numPortals
new numTargets
new numAllrounds
new numBlackholes

new portal_model[64] = "sprites/e-tele1.spr"
new target_model[64] = "sprites/b-tele1.spr"
new allround_model[64] = "sprites/exit1.spr"
new blackhole_model[64] = "models/blackhole.mdl"

public plugin_precache() {
	precache_model(portal_model)
	precache_model(target_model)
	precache_model(allround_model)
	precache_model(blackhole_model)
	precache_sound("debris/beamstart1.wav")
	precache_sound("debris/beamstart7.wav")
}

public plugin_init() {
	register_plugin("AMX Portal", "1.4", "KleeneX")
	register_clcmd("amx_portal","create_portal",ADMIN_FLAG,": Create a Portal")
	register_clcmd("amx_ptarget","create_target",ADMIN_FLAG,": Create a Portal Target")
	register_clcmd("amx_aportal","create_allround",ADMIN_FLAG,": Create a Allround")
	register_clcmd("amx_blackhole","create_blackhole",ADMIN_FLAG,": Create a Blackhole")
	
	register_clcmd("amx_r_portal","remove_portal",ADMIN_FLAG,": Remove all Portals")
	register_clcmd("amx_r_ptarget","remove_target",ADMIN_FLAG,": Remove all Targets")
	register_clcmd("amx_r_aportal","remove_allround",ADMIN_FLAG,": Remove all Allrounds")
	register_clcmd("amx_r_blackhole","remove_blackhole",ADMIN_FLAG,": Remove all Blackholes")
	
	register_clcmd("amx_portalmenu","cmdPortalMenu",ADMIN_FLAG,": Open the Portal Menu")
	register_menucmd(register_menuid("\rPortal Menu:"),1023,"actionPortalMenu")
}

public create_portal(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	if(numPortals == MAX_PORTALS) {
		console_print(id, "Too many portals.")
		return PLUGIN_HANDLED
	}
	
	new Origin[3]
	get_user_origin(id,Origin)
	
	new Float:pOrigin[3]
	IVecFVec(Origin, Float:pOrigin)
	
	new portal = create_entity("info_target")
	entity_set_string(portal,EV_SZ_classname,"amx_portal")
	
	entity_set_model(portal, portal_model)
	entity_set_int(portal, EV_INT_flags, FL_ALWAYSTHINK)
	set_rendering(portal, kRenderFxNone, 0, 0, 0, kRenderTransAdd, 255)
	
	new Float:MinBox[3] = {-16.0, -16.0, 0.0}
	new Float:MaxBox[3] = {16.0, 16.0, 16.0}
	entity_set_vector(portal, EV_VEC_mins, MinBox)
	entity_set_vector(portal, EV_VEC_maxs, MaxBox)
	
	entity_set_int(portal, EV_INT_solid, 1)
	
	pOrigin[1] += 50
	entity_set_origin(portal,pOrigin)
	
	mapPortals[numPortals] = portal
	++numPortals
	return PLUGIN_HANDLED
}

public create_target(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	if(numTargets == MAX_TARGETS) {
		console_print(id, "Too many targets.")
		return PLUGIN_HANDLED
	}
	
	new Origin[3]
	get_user_origin(id,Origin)
	
	new Float:pOrigin[3]
	IVecFVec(Origin, Float:pOrigin)
	
	new target = create_entity("info_target")
	entity_set_string(target,EV_SZ_classname,"amx_ptarget")
	
	entity_set_model(target, target_model)
	entity_set_int(target, EV_INT_flags, FL_ALWAYSTHINK)
	set_rendering(target, kRenderFxNone, 0, 0, 0, kRenderTransAdd, 255)
	
	pOrigin[1] += 50
	entity_set_origin(target,pOrigin)
	
	mapTargets[numTargets] = target
	++numTargets
	return PLUGIN_HANDLED
}

public create_allround(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	if(numAllrounds == MAX_ALLROUNDS) {
		console_print(id, "Too many allrounds.")
		return PLUGIN_HANDLED
	}
	
	new Origin[3]
	get_user_origin(id,Origin)
	
	new Float:pOrigin[3]
	IVecFVec(Origin, Float:pOrigin)
	
	new allround = create_entity("info_target")
	entity_set_string(allround,EV_SZ_classname,"amx_aportal")
	
	entity_set_model(allround, allround_model)
	entity_set_int(allround, EV_INT_flags, FL_ALWAYSTHINK)
	set_rendering(allround, kRenderFxNone, 0, 0, 0, kRenderTransAdd, 255)
	
	new Float:MinBox[3] = {-16.0, -16.0, 0.0}
	new Float:MaxBox[3] = {16.0, 16.0, 16.0}
	entity_set_vector(allround, EV_VEC_mins, MinBox)
	entity_set_vector(allround, EV_VEC_maxs, MaxBox)
	
	entity_set_int(allround, EV_INT_solid, 1)
	
	pOrigin[1] += 50
	entity_set_origin(allround,pOrigin)
	
	mapAllrounds[numAllrounds] = allround
	++numAllrounds
	return PLUGIN_HANDLED
}

public create_blackhole(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	if(numBlackholes == MAX_BLACKHOLES) {
		console_print(id, "Too many blackholes.")
		return PLUGIN_HANDLED
	}
	
	new Float:vOrigin[3]
	new Float:vAngles[3]
	entity_get_vector(id, EV_VEC_origin, vOrigin)
	entity_get_vector(id, EV_VEC_v_angle, vAngles)
	
	new blackhole = create_entity("info_target")
	
	entity_set_string(blackhole, EV_SZ_classname, "amx_blackhole")
	
	entity_set_model(blackhole, blackhole_model)
	entity_set_size(blackhole, Float:{-40.0,-30.0,-40.0}, Float:{40.0,30.0,40.0})
	
	new Float:vNewOrigin[3]
	new Float:vNormal[3]
	new Float:vTraceDirection[3]
	new Float:vTraceEnd[3]
	new Float:vTraceResult[3]
	new Float:vEntAngles[3]
	
	VelocityByAim(id, 64, vTraceDirection)
	
	vTraceEnd[0] = vTraceDirection[0] + vOrigin[0]
	vTraceEnd[1] = vTraceDirection[1] + vOrigin[1]
	vTraceEnd[2] = vTraceDirection[2] + vOrigin[2]
	
	trace_line(id, vOrigin, vTraceEnd, vTraceResult)
	
	if(trace_normal(id, vOrigin, vTraceEnd, vNormal) == 0) {
		remove_entity(blackhole)
		console_print(id, "You must create a blackhole on a wall!")
		return PLUGIN_HANDLED_MAIN
	}
	
	vNewOrigin[0] = vTraceResult[0] + (vNormal[0] * 10.0)
	vNewOrigin[1] = vTraceResult[1] + (vNormal[1] * 10.0)
	vNewOrigin[2] = vTraceResult[2] + (vNormal[2] * 10.0)
	
	entity_set_int(blackhole, EV_INT_solid, 1)
	entity_set_int(blackhole, EV_INT_flags, FL_ALWAYSTHINK)
	
	entity_set_origin(blackhole, vNewOrigin)
	vector_to_angle(vNormal, vEntAngles)
	
	entity_set_vector(blackhole, EV_VEC_angles, vEntAngles)
	
	mapBlackholes[numBlackholes] = blackhole
	++numBlackholes
	return PLUGIN_HANDLED
}

public remove_portal(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	for(new a = 0; a < numPortals; a++) {
		remove_entity(mapPortals[a])
	}
	numPortals = 0
	return PLUGIN_HANDLED
}

public remove_target(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	for(new a = 0; a < numTargets; a++) {
		remove_entity(mapTargets[a])
	}
	numTargets = 0
	return PLUGIN_HANDLED
}

public remove_allround(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	for(new a = 0; a < numAllrounds; a++) {
		remove_entity(mapAllrounds[a])
	}
	numAllrounds = 0
	return PLUGIN_HANDLED
}

public remove_blackhole(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	for(new a = 0; a < numBlackholes; a++) {
		remove_entity(mapBlackholes[a])
	}
	numBlackholes = 0
	return PLUGIN_HANDLED
}

public server_frame() {
	for(new a = 0; a <= numPortals; ++a) {
		if(is_valid_ent(mapPortals[a])) {
			if(entity_get_float(mapPortals[a], EV_FL_frame) < 0.0 || entity_get_float(mapPortals[a], EV_FL_frame) > 25) {
				entity_set_float(mapPortals[a], EV_FL_frame, 0.0)
			}
			else entity_set_float(mapPortals[a], EV_FL_frame, entity_get_float(mapPortals[a], EV_FL_frame) + 0.5)
		}
	}
	for(new a = 0; a <= numTargets; ++a) {
		if(is_valid_ent(mapTargets[a])) {
			if(entity_get_float(mapTargets[a], EV_FL_frame) < 0.0 || entity_get_float(mapTargets[a], EV_FL_frame) > 25) {
				entity_set_float(mapTargets[a], EV_FL_frame, 0.0)
			}
			else entity_set_float(mapTargets[a], EV_FL_frame, entity_get_float(mapTargets[a], EV_FL_frame) + 0.5)
		}
	}
	for(new a = 0; a <= numAllrounds; ++a) {
		if(is_valid_ent(mapAllrounds[a])) {
			if(entity_get_float(mapAllrounds[a], EV_FL_frame) < 0.0 || entity_get_float(mapAllrounds[a], EV_FL_frame) > 25) {
				entity_set_float(mapAllrounds[a], EV_FL_frame, 0.0)
			}
			else entity_set_float(mapAllrounds[a], EV_FL_frame, entity_get_float(mapAllrounds[a], EV_FL_frame) + 0.5)
		}
	}
	for(new a = 0; a <= numBlackholes; ++a) {
		if(is_valid_ent(mapBlackholes[a])) {
			if(entity_get_float(mapBlackholes[a], EV_FL_frame) < 195.0 || entity_get_float(mapBlackholes[a], EV_FL_frame) > 255) {
				entity_set_float(mapBlackholes[a], EV_FL_frame, 195.0)
			}
			else entity_set_float(mapBlackholes[a], EV_FL_frame, entity_get_float(mapBlackholes[a], EV_FL_frame) + 1.5)
		}
	}
}

public pfn_touch(ptr,ptd) {
	if (ptr > 0 && ptd > 0) {
		new Portal[32]
		entity_get_string(ptr, EV_SZ_classname, Portal, 31)
		if ( equal(Portal,"amx_portal") ) {
			if(numTargets == 0) return PLUGIN_HANDLED
			else{
				new random_target, Origin[3]
				new Float:eOrigin[3]
				random_target = mapTargets[random_num(0,numTargets - 1)]
				entity_get_vector(random_target, EV_VEC_origin, eOrigin )
				FVecIVec(Float:eOrigin,Origin)
				
				Origin[0] += 80
				Origin[1] += 80
				Origin[2] += 10
				
				new Float:velocity[3]
				entity_get_vector(ptd, EV_VEC_velocity, velocity)
				emit_sound(ptr, CHAN_WEAPON, "debris/beamstart1.wav", 0.4, ATTN_NORM, 0, PITCH_NORM)
				
				set_user_origin(ptd,Origin)
				
				velocity[2] = random_float(200.0, 225.0)
				entity_set_vector(ptd, EV_VEC_velocity, velocity)
				emit_sound(random_target, CHAN_WEAPON, "debris/beamstart7.wav", 0.4, ATTN_NORM, 0, PITCH_NORM)
			}
		}
		if ( equal(Portal,"amx_aportal") ) {
			if(numAllrounds == 1) return PLUGIN_HANDLED
			else{
				new random_target, Origin[3]
				new Float:eOrigin[3]
				random_target = mapAllrounds[random_num(0,numAllrounds - 1)]
				if(random_target != ptr) {
					entity_get_vector(random_target, EV_VEC_origin, eOrigin )
					FVecIVec(Float:eOrigin,Origin)
					
					Origin[0] += 80
					Origin[1] += 80
					Origin[2] += 10
					
					new Float:velocity[3]
					entity_get_vector(ptd, EV_VEC_velocity, velocity)
					emit_sound(ptr, CHAN_WEAPON, "debris/beamstart1.wav", 0.4, ATTN_NORM, 0, PITCH_NORM)
					
					set_user_origin(ptd,Origin)
					
					velocity[2] = random_float(200.0, 225.0)
					entity_set_vector(ptd, EV_VEC_velocity, velocity)
					emit_sound(random_target, CHAN_WEAPON, "debris/beamstart7.wav", 0.4, ATTN_NORM, 0, PITCH_NORM)
				}
			}
		}
		if ( equal(Portal,"amx_blackhole") ) {
			if(numBlackholes == 1) {
				//user_kill(ptd,1)
				return PLUGIN_HANDLED
				}else{
				new random_target
				new Float:eOrigin[3]
				random_target = mapBlackholes[random_num(0,numBlackholes - 1)]
				if(random_target != ptr) {
					entity_get_vector(random_target, EV_VEC_origin, eOrigin )
					
					new Float:vEntAngles[3]
					entity_get_vector(random_target, EV_VEC_angles, vEntAngles)
					
					if(vEntAngles[0] < 181)
					eOrigin[2] += 50
					else if(vEntAngles[0] < 361)	
					eOrigin[2] -= 50
					
					if(vEntAngles[1] == 0)
					eOrigin[0] += 80
					else if(vEntAngles[1] < 91)
					eOrigin[1] += 80
					else if(vEntAngles[1] < 181)
					eOrigin[0] -= 80
					else if(vEntAngles[1] < 271)
					eOrigin[1] -= 80
					
					new Float:velocity[3]
					new players[32],pnum
					get_players(players,pnum)
					entity_get_vector(ptd, EV_VEC_velocity, velocity)
					
					emit_sound(ptr, CHAN_WEAPON, "debris/beamstart1.wav", 0.4, ATTN_NORM, 0, PITCH_NORM)
					entity_set_vector(ptd,EV_VEC_origin,eOrigin)
					emit_sound(random_target, CHAN_WEAPON, "debris/beamstart7.wav", 0.4, ATTN_NORM, 0, PITCH_NORM)
					
					if(vEntAngles[0] < 361 && vEntAngles[0] > 180)	
					velocity[2] = random_float(-200.0, -225.0)
					else
					velocity[2] = random_float(200.0, 225.0)
					entity_set_vector(ptd, EV_VEC_velocity, velocity)
				}
			}
		}
	}
	return PLUGIN_CONTINUE
}

public cmdPortalMenu(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) return PLUGIN_HANDLED
	displayPortalMenu(id)
	return PLUGIN_HANDLED
}

public displayPortalMenu(id) {
	new MenuBody[256], keys
	
	new nLen = format( MenuBody, 255, "\rPortal Menu:^n" )
	
	if (numPortals == MAX_PORTALS) nLen += format( MenuBody[nLen], 255-nLen,"^n\w1. Create Portal \r(Limit reached)")
	else nLen += format( MenuBody[nLen], 255-nLen, "^n\w1. Create Portal" )
	if (numTargets == MAX_TARGETS) nLen += format( MenuBody[nLen],255-nLen,"^n\w2. Create Target \r(Limit reached)")
	else nLen += format( MenuBody[nLen],255-nLen,"^n\w2. Create Target")
	if (numAllrounds == MAX_ALLROUNDS) nLen += format( MenuBody[nLen],255-nLen,"^n\w3. Create Allround \r(Limit reached)")
	else nLen += format( MenuBody[nLen],255-nLen,"^n\w3. Create Allround")
	if (numBlackholes == MAX_BLACKHOLES) nLen += format( MenuBody[nLen],255-nLen,"^n\w4. Create Blackhole \r(Limit reached)^n")
	else nLen += format( MenuBody[nLen],255-nLen,"^n\w4. Create Blackhole^n")
	nLen += format( MenuBody[nLen], 255-nLen, "^n\w5. Remove Portals" )
	nLen += format( MenuBody[nLen], 255-nLen, "^n\w6. Remove Targets" )
	nLen += format( MenuBody[nLen], 255-nLen, "^n\w7. Remove Allround" )
	nLen += format( MenuBody[nLen], 255-nLen, "^n\w8. Remove Blackholes^n" )
	nLen += format( MenuBody[nLen], 255-nLen, "^n\y0. Exit" )
	
	keys = (1<<0|1<<1|1<<2|1<<3|1<<4|1<<5|1<<6|1<<7|1<<8|1<<9)
	
	show_menu( id, keys, MenuBody, -1)
	
	return PLUGIN_CONTINUE
}

public actionPortalMenu(id,key) {
	new cid, level
	switch(key) {
		case 0: create_portal(id,level,cid)
		case 1: create_target(id,level,cid)
		case 2: create_allround(id,level,cid)
		case 3: create_blackhole(id,level,cid)
		case 4: remove_portal(id,level,cid)
		case 5: remove_target(id,level,cid)
		case 6: remove_allround(id,level,cid)
		case 7: remove_blackhole(id,level,cid)
	}
	if (key != 9) displayPortalMenu(id)
	return PLUGIN_HANDLED
}