
#include <amxmodx>
#include <amxmisc>

#include <hamsandwich>
#include <fakemeta>
#include <fakemeta_util>
#include <engine>

#include <cstrike>

#include <xs>

new const Plugin[] = "Lucia"
new const Author[] = "joaquimandrade"
new const Version[]	= "1.0"


new const AdminFlag = ADMIN_BAN

new HideEntitiesClasses[][] = {"func_wall","func_breakable"}

new Array:PossibleHideEntitiesList

new Array:HideEntitiesList
new Array:HideEntitiesOriginList

const MaxEntities = 1500

new IsHideEntity[MaxEntities / 32 + _:!!(MaxEntities % 32)]

new const Float:PlayerRay = 22.0

new const Float:HullFactor = 0.5

//new const Float:FriendMinDistance = 2000.0
new const Float:ChangeMinDistance = 100.0

new BotID
new SuspectID

new PlayerModels[CsTeams][] = 
{
	"",
	"models/player/guerilla/guerilla.mdl",
	"models/player/sas/sas.mdl",
	""
}

new BotClass[] = "lucia"

new CsTeams:TeamSum = CS_TEAM_T + CS_TEAM_CT

new HamHook:ForwardBotThink
new HamHook:ForwardKill
new ForwardAddToFullPack

new Float:BotThinkDelay = 1.0

new Float:HiddenLocation[3] = {-10000.0,-10000.0,-10000.0}

new IsAdmin[33 char]

new MaxPlayers

new const PluginTag[] = "[Lucia]"
new const MessageNoSpots[] = "This map doesn't have any available hide spot"
new const MessageSuspectLeft[] = "The suspect ^"%s^" has left the server"
new const MessageNowSuspect[] = "Player ^"%s^" is now a suspect"
new const MessageNowNotSuspect[] = "Player ^"%s^" is no longer a suspect"
new const MenuTitle[] = "Suspect Menu"
new MenuTitleTagged[charsmax(PluginTag) + 1 + charsmax(MenuTitle) + 1]

public plugin_precache()
{
	PossibleHideEntitiesList = ArrayCreate()
	
	for(new i=0;i<sizeof HideEntitiesClasses;i++)
	{
		RegisterHam(Ham_Spawn,HideEntitiesClasses[i],"hideEntitySpawn",1)
	}
	
	for(new CsTeams:i=CS_TEAM_T;i<=CS_TEAM_CT;i++)
	{
		precache_model(PlayerModels[i])
	}
}

public hideEntitySpawn(id)
{
	ArrayPushCell(PossibleHideEntitiesList,id)
}

public plugin_init()
{
	register_plugin(Plugin,Version,Author)
	
	HideEntitiesOriginList = ArrayCreate(3)
	HideEntitiesList = ArrayCreate()
	
	validateHideEntities(PossibleHideEntitiesList,HideEntitiesOriginList,HideEntitiesList)	
	
	if(ArraySize(HideEntitiesList))
	{
		DisableHamForward( ForwardBotThink = RegisterHam(Ham_Think,"info_target","botThink") )
		DisableHamForward( ForwardKill = RegisterHam(Ham_Killed,"player","playerKill") )
		
		register_forward(FM_ClientDisconnect,"clientDisconnect")
		
		MaxPlayers = get_maxplayers()
		
		register_clcmd("lucia","suspectCommand",AdminFlag)
		
		format(MenuTitleTagged,charsmax(MenuTitleTagged),"%s %s",PluginTag,MenuTitle)
	}
	else
	{
		register_clcmd("lucia","suspectCommandDisabled",AdminFlag)
	}
	
	register_cvar("lucia_version",Version,FCVAR_SERVER|FCVAR_SPONLY)
}

public suspectCommand(id,level,cid)
{
	if(cmd_access(id,level,cid,1))
	{
		if(SuspectID)
		{
			menuUnsuspect(id)
		}
		else
		{
			menuSuspect(id);
		}
	}
	
	return PLUGIN_HANDLED
}

menuUnsuspect(id)
{
	static name[32]
	get_user_name(SuspectID,name,charsmax(name))
	
	static currentlySuspecting[] = "^n^n\wCurrently Suspecting ^"\r%s\y^"^n"
	
	static currentlySuspectingNamed[charsmax(currentlySuspecting) + charsmax(name)] 
	formatex(currentlySuspectingNamed,charsmax(currentlySuspectingNamed),currentlySuspecting,name)
	
	static menuTitleTaggedNameInfo[charsmax(MenuTitleTagged) + charsmax(currentlySuspectingNamed) + 1]
	formatex(menuTitleTaggedNameInfo,charsmax(menuTitleTaggedNameInfo),"%s%s",MenuTitleTagged,currentlySuspectingNamed)
	
	new menu = menu_create(menuTitleTaggedNameInfo,"handleMenuUnsuspect")

	menu_additem(menu,"Stop","1")
	menu_additem(menu,"Stop and select another player ","2")
	
	menu_display(id,menu)
}

public handleMenuUnsuspect(id,menu,item)
{
	if(item >= 0) 
	{		
		if(is_user_connected(SuspectID))
		{
			new access, callback; 
		
			new iString[2];		
			menu_item_getinfo(menu,item,access,iString,charsmax(iString),.callback=callback);	
			
			new i = str_to_num(iString)
			
			new suspectID = SuspectID
			
			switch(i)
			{
				case 1:
				{
					unsuspect()
				}
				case 2:
				{
					unsuspect()
					menuSuspect(id)
				}
			}
			
			static name[32]
			get_user_name(suspectID,name,charsmax(name))
			
			static messageNowNotSuspectWithName[charsmax(MessageNowNotSuspect) + charsmax(name) + 1]
			
			formatex(messageNowNotSuspectWithName,charsmax(messageNowNotSuspectWithName),MessageNowNotSuspect,name)
			
			for(new i=1;i<=MaxPlayers;i++)
			{
				if(IsAdmin{i} && is_user_connected(i))
				{
					client_print(i,print_chat,"%s %s",PluginTag,messageNowNotSuspectWithName)
				}
			}
			
		}
	}
	
	menu_destroy(menu)
}

menuSuspect(id)
{
	new menu = menu_create(MenuTitleTagged,"handleMenuSuspect")
	
	for(new i=1;i<=MaxPlayers;i++)
	{
		if(!IsAdmin{i} && is_user_connected(i) && (CS_TEAM_T <= cs_get_user_team(i) <= CS_TEAM_CT))
		{
			static iString[3]
			num_to_str(i,iString,charsmax(iString))
			
			static name[32]
			get_user_name(i,name,charsmax(name))
			
			menu_additem(menu,name,iString)
		}
	}
	
	menu_display(id,menu)
}

public handleMenuSuspect(id,menu,item)
{
	if(item >= 0) 
	{
		new access, callback; 
		
		new iString[3];		
		menu_item_getinfo(menu,item,access,iString,charsmax(iString),.callback=callback);		
		
		new i = str_to_num(iString)
		
		if(is_user_connected(i))
		{
			suspectPlayer(i)
		}
	}
	
	menu_destroy(menu)
}

public suspectCommandDisabled(id,level,cid)
{
	if(cmd_access(id,level,cid,1))
	{
		client_print(id,print_console,"%s %s",PluginTag,MessageNoSpots)
	}
	
	return PLUGIN_HANDLED
}

public client_authorized(id)
{
	IsAdmin{id} = get_user_flags(id) & AdminFlag
}

public clientDisconnect(id)
{
	if(id == SuspectID)
	{
		unsuspect()
		
		static name[32]
		get_user_name(id,name,charsmax(name))
		
		static messageSuspectLeftWithName[charsmax(MessageSuspectLeft) + charsmax(name) + 1]
		
		formatex(messageSuspectLeftWithName,charsmax(messageSuspectLeftWithName),MessageSuspectLeft,name)
		
		for(new i=1;i<=MaxPlayers;i++)
		{
			if(IsAdmin{i} && is_user_connected(i))
			{
				client_print(i,print_chat,"%s %s",PluginTag,messageSuspectLeftWithName)
			}
		}
	}
}

hullCheck(Float:origin[3],trace)
{	
	static Float:margin[3]
	
	xs_vec_copy(origin,margin)
	
	for(new i=0;i<3;i++)
		margin[i] += HullFactor
	
	engfunc(EngFunc_TraceHull,origin,margin,1,HULL_POINT,0,trace)
	return get_tr2(trace,TR_AllSolid)
	
}

bool:isSafeHideOrigin(Float:origin[3],trace)
{
	static Float:centerPoints[3][3]
	static Float:centerPointsZDistanceMultiply[3] = {1.0,0.0,-1.0}
	
	for(new i=0;i<3;i++)
	{
		xs_vec_copy(origin,centerPoints[i])
		centerPoints[i][2] += centerPointsZDistanceMultiply[i] * (PlayerRay)
		
		if(!hullCheck(centerPoints[i],trace))
		{
			return false
		}
		
		static Float:borderPointsXYDistanceMultiply[4][2] = {{0.0,1.0},{1.0,0.0},{0.0,-1.0},{-1.0,0.0}}
		
		for(new j=0;j<4;j++)
		{
			static Float:borderPoint[3]
			xs_vec_copy(centerPoints[i],borderPoint)
			
			for(new k=0;k<2;k++)
			{
				borderPoint[k] += borderPointsXYDistanceMultiply[j][k] * (PlayerRay)
			}
			
			if(!hullCheck(borderPoint,trace))
			{
				return false
			}
		}
	}
	
	return true
}

validateHideEntities(Array:possibleEntitiesList,Array:entitiesOriginList,Array:entitiesList)
{
	new trace = create_tr2()
	
	for(new i=0;i<ArraySize(possibleEntitiesList);i++)
	{
		new id = ArrayGetCell(possibleEntitiesList,i)
		
		static Float:renderMode
		pev(id,pev_rendermode,renderMode)
		
		if(renderMode == kRenderNormal)
		{
			static Float:origin[3]
			get_brush_entity_origin(id,origin)
			
			static Float:mins[3],Float:maxs[3]
			pev(id,pev_mins,mins)
			pev(id,pev_maxs,maxs)
			
			origin[2] -= floatabs(mins[2] - maxs[2]) * 0.5
			origin[2] += PlayerRay
			
			if(isSafeHideOrigin(origin,trace))
			{	
				ArrayPushArray(entitiesOriginList,origin)
				ArrayPushCell(entitiesList,id)
				
				IsHideEntity[id >> 5] |= 1 << (id & 31); 
			}
		}
	}
	
	free_tr2(trace)
}

public addToFullPack(es, e, ent, host, hostflags, player, pSet)
{
	if(IsHideEntity[ent >> 5] & (1 << (ent & 31)) && (IsAdmin{host}) && !is_user_alive(host))
	{
		set_es(es,ES_RenderMode,kRenderTransTexture)
		set_es(es,ES_RenderAmt,80)
	}
}

createBot(model[],class[],CsTeams:team)
{
	new botID = create_entity("info_target")
	
	assert botID;
	
	set_pev(botID,pev_solid,SOLID_NOT);
	set_pev(botID,pev_classname,class)
	set_pev(botID,pev_team,team)
	
	entity_set_model(botID,model)
	
	entity_set_float(botID,EV_FL_framerate,1.0)
	entity_set_int(botID,EV_INT_sequence,2);
	
	entity_set_origin(botID,HiddenLocation)
	
	return botID
}

suspectPlayer(id)
{
	if(BotID)
	{
		unsuspect()
	}
	
	ForwardAddToFullPack = register_forward(FM_AddToFullPack,"addToFullPack",1)
	EnableHamForward(ForwardBotThink)	
	EnableHamForward(ForwardKill)
	
	new CsTeams:team = TeamSum - cs_get_user_team(id)	
	
	BotID = createBot(PlayerModels[team],BotClass,team)
	SuspectID = id
	
	static name[32]
	get_user_name(SuspectID,name,charsmax(name))
	
	static messageNowSuspectWithName[charsmax(MessageNowSuspect) + charsmax(name) + 1]
	
	formatex(messageNowSuspectWithName,charsmax(messageNowSuspectWithName),MessageNowSuspect,name)
	
	for(new i=1;i<=MaxPlayers;i++)
	{
		if(IsAdmin{i} && is_user_connected(i))
		{
			client_print(i,print_chat,"%s %s",PluginTag,messageNowSuspectWithName)
		}
	}
	
	botThink(BotID)
}

unsuspect()
{
	unregister_forward(FM_AddToFullPack,ForwardAddToFullPack,1)
	DisableHamForward(ForwardBotThink)
	DisableHamForward(ForwardKill)
	
	remove_entity(BotID)
	SuspectID = 0
	BotID = 0
}

public playerKill(id,attackerID,shouldgib)
{
	if(id == SuspectID)
	{
		entity_set_origin(BotID,HiddenLocation)
	}
}

/*
checkFriendsDistance(Float:point[3],CsTeams:team)
{
	for(new i=1;i<=MaxPlayers;i++)
	{
		if(is_user_alive(i) && (cs_get_user_team(i) == team))
		{
			static Float:origin[3]
			pev(i,pev_origin,origin)
			
			static Float:distance
			distance = vector_distance(point,origin)
			
			if(distance <= FriendMinDistance)
			{
				return true;
			}
		}
	}
	
	return false;
}
*/

public botThink(id)
{	
	if(id == BotID)
	{		
		if(is_user_alive(SuspectID))
		{
			static Float:botOrigin[3]
			pev(id,pev_origin,botOrigin)
			
			if(!is_in_viewcone(SuspectID,botOrigin,1))
			{
				static Float:suspectOrigin[3]
				pev(SuspectID,pev_origin,suspectOrigin)
			
				static Float:currentDistance
				currentDistance = vector_distance(suspectOrigin,botOrigin)
				
				if(currentDistance > ChangeMinDistance)
				{
					new closerValidPointID = -1
					
					for(new i=0;i<ArraySize(HideEntitiesOriginList);i++)
					{
						static Float:point[3]
						ArrayGetArray(HideEntitiesOriginList,i,point)
						
						static Float:distance 
						distance = vector_distance(suspectOrigin,point)
						
						if(ChangeMinDistance <= distance < currentDistance)
						{
							if(!is_in_viewcone(SuspectID,point,1))
							{
								/*
								if(checkFriendsDistance(point,CsTeams:pev(id,pev_team)))
								{
								}
								*/
								currentDistance = distance
								closerValidPointID = i
							}
						}
					}
					
					if(closerValidPointID != -1)
					{
						ArrayGetArray(HideEntitiesOriginList,closerValidPointID,botOrigin)
						entity_set_origin(id,botOrigin);
					}
					
				}
			}
		}
		
		//client_print(0,print_chat,"Bot thought")
		set_pev(id,pev_nextthink,get_gametime() + BotThinkDelay)
	}
}

