# -*- coding:Utf-8 -*-

import es
import playerlib

gm_info = es.AddonInfo() 
gm_info.name = 'Gore Effects' 
gm_info.basename = 'goremod'
gm_info.version = '1.0 by L\'in20Cible'
gm_info.url = 'http://addons.eventscripts.com/addons/view/goremod'
gm_info.description = 'Simulate a gore effect on your server'
gm_info.author = 'L\'In20Cible' 
es.ServerVar('gore_effects_version', gm_info.version).makepublic()

goremod_blood_enable = es.ServerVar('goremod_blood_enable', 1)
goremod_blood_amount = es.ServerVar('goremod_blood_amount', 25)
goremod_blood_alien = es.ServerVar('goremod_blood_alien', 0)

goremod_explosion_enable = es.ServerVar('goremod_explosion_enable', 1)
goremod_explosion_skulls = es.ServerVar('goremod_explosion_skulls', 1)
goremod_explosion_scapulas = es.ServerVar('goremod_explosion_scapulas', 2)
goremod_explosion_spines = es.ServerVar('goremod_explosion_spines', 1)
goremod_explosion_ribs = es.ServerVar('goremod_explosion_ribs', 10)
goremod_explosion_lifetime = es.ServerVar('goremod_explosion_lifetime', 30)
goremod_explosion_weapons = es.ServerVar('goremod_explosion_weapons', 'world,worldspawn,hegrenade,knife')
goremod_explosion_headshot = es.ServerVar('goremod_explosion_headshot', 1)
goremod_explosion_teamkill = es.ServerVar('goremod_explosion_teamkill', 1)
goremod_explosion_blood = es.ServerVar('goremod_explosion_blood', 50)
goremod_explosion_ragdoll = es.ServerVar('goremod_explosion_ragdoll', 1)

goremod_sound_enable = es.ServerVar('goremod_sound_enable', 1)
goremod_sound_download = es.ServerVar('goremod_sound_download', 1) 
goremod_sound_filepath = es.ServerVar('goremod_sound_filepath', 'goremod/explosion.wav')
goremod_sound_volume = es.ServerVar('goremod_sound_volume', 1.0)
goremod_sound_attenuation = es.ServerVar('goremod_sound_attenuation', 0.5)

def load():
   initialisation()
   
def es_map_start(event):
   initialisation()
   
def initialisation():
   es.server.queuecmd('es_xmexec ../addons/eventscripts/goremod/goremod.cfg')
   
   if int(goremod_sound_enable) and int(goremod_sound_download):
      es.stringtable('downloadables', 'sound/%s' % goremod_sound_filepath) 

def player_hurt(event):
   if int(goremod_blood_enable):
      blood(int(event['userid']), (int(goremod_blood_amount) + int(event['dmg_health']) - int(event['dmg_armor'])))

def player_death(event):
   if int(goremod_explosion_enable) and event['weapon'] in str(goremod_explosion_weapons).split(',') or int(goremod_explosion_headshot) and int(event['headshot']) or int(goremod_explosion_teamkill) and int(event['es_attackerteam']) == int(event['es_userteam']):
      
      if int(goremod_explosion_ragdoll):
         handle = es.getplayerhandle(event['userid'])
         for ragdoll in es.createentitylist('cs_ragdoll'):
            if es.getindexprop(ragdoll, 'CCSRagdoll.m_hPlayer') == handle:
               es.server.queuecmd('es_xremove %i' % int(ragdoll))
               
      if int(goremod_explosion_blood):
         blood(int(event['userid']), int(goremod_explosion_blood))
         
      if int(goremod_sound_enable):
         es.emitsound('player', event['userid'], str(goremod_sound_filepath), float(goremod_sound_volume), float(goremod_sound_attenuation))
         
      location = es.getplayerlocation(event['userid'])
         
      if int(goremod_explosion_skulls):
         shoot(int(event['userid']), str('goremod_skulls_%i' % int(event['userid'])), location, 'hgibs', int(goremod_explosion_skulls))
         
      if int(goremod_explosion_scapulas):
         shoot(int(event['userid']), str('goremod_scapulas_%i' % int(event['userid'])), location, 'hgibs_scapula', int(goremod_explosion_scapulas))
         
      if int(goremod_explosion_spines):
         shoot(int(event['userid']), str('goremod_spines_%i' % int(event['userid'])), location, 'hgibs_spine', int(goremod_explosion_spines))
         
      if int(goremod_explosion_ribs):
         shoot(int(event['userid']), str('goremod_ribs_%i' % int(event['userid'])), location, 'hgibs_rib', int(goremod_explosion_ribs))
         
def give(userid, entity):
   if not es.getplayerprop(userid, 'CBasePlayer.pl.deadflag'):
      player = playerlib.getPlayer(userid)
         
      primary = player.get('primary')
      if primary:
         primary_ammo = player.get('ammo', primary)
         primary_clip = player.get('clip', primary)
            
      secondary = player.get('secondary')
      if secondary:
         secondary_ammo = player.get('ammo', secondary)
         secondary_clip = player.get('clip', secondary)
            
      es.server.cmd('es_xgive %i %s' % (userid, entity))
         
      if primary:
         player.set('ammo', (primary, primary_ammo))
         player.set('clip', (primary, primary_clip))
            
      if secondary:
         player.set('ammo', (secondary, secondary_ammo))
         player.set('clip', (secondary, secondary_clip))
   else:
      es.server.queuecmd('es_xgive %i %s' % (userid, entity))
         
def blood(userid, amount):
   give(userid, 'env_blood')
   es.server.queuecmd('es_xfire %i env_blood addoutput "spawnflags 121"' % userid)
   es.server.queuecmd('es_xfire %i env_blood addoutput "amount %i"' % (userid, amount))
   es.server.queuecmd('es_xfire %i env_blood addoutput "color %i"' % (userid, int(goremod_blood_alien)))
   es.server.queuecmd('es_xfire %i env_blood emitblood;' % userid)
   es.server.queuecmd('es_xfire %i env_blood kill' % userid)
   
def shoot(userid, name, origin, model, amount):
   give(userid, 'env_shooter')
   es.server.queuecmd('es est_setentname server_var(eventscripts_lastgive) %s' % name)
   es.server.queuecmd('es_xfire %i %s addoutput "angles 0 0 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "m_iGibs %i"' % (userid, name, amount))
   es.server.queuecmd('es_xfire %i %s addoutput "delay 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "gibangles 0 0 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "m_flVelocity 250"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "m_flVariance 500"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "m_flGibLife %i"' % (userid, name, int(goremod_explosion_lifetime)))
   es.server.queuecmd('es_xfire %i %s addoutput "lightingorigin 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "renderfx 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "rendermode 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "renderamt 255"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "rendercolor 255 255 255"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "disablereceiveshadows 1"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "shootmodel models/gibs/%s.mdl"' % (userid, name, model))
   es.server.queuecmd('es_xfire %i %s addoutput "shootsounds -1"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "simulation 1"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "skin 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "gibanglevelocity -250"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "lightingorigin 0"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "nogibshadows 1"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "gibgravityscale 0.9"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s addoutput "spawnflags 4"' % (userid, name))
   es.server.queuecmd('es_xfire %i %s shoot' % (userid, name))