#pragma once

#include "osconfig.h"
#include "dynpatcher_base.h"

extern generic_dlldata_t GenericEngineData; //keeps info about swds.dll (sections, etc)

#ifdef _WIN32
	struct EngineData_t {
		uint32_t Limit1000FPS_haddr;
		uint32_t Limit1000FPS_JumpAddr;
		uint32_t Sleep_addr;
		uint32_t NtDelayExecution_addr;
	};
#else //linux
	struct EngineData_t {
		void* hLib;
		void* libBase;

		uint32_t Host_Speeds_addr;
		uint32_t Host_Speeds_jaddr;

		uint32_t FilterTime_NopsAddr;
		uint32_t Sys_Sleep_addr;
	};

#endif

extern EngineData_t DSEngineData; //conatins all offsets/addrs required to patch


/* Function protocols */

#ifdef _WIN32
	typedef DWORD (WINAPI *NtDelayExecution_proto)(BOOL Alertable, PLARGE_INTEGER DelayInterval); 
#else
	typedef void (CDECL *Host_Speeds_proto)(void *hspd);
#endif


/* ======= Functions =======*/
extern bool mmtimer_init();
extern void mmtimer_end();

#ifdef _WIN32
	extern bool ParseEngine_Win();
	extern NtDelayExecution_proto NtDelayExecution_func;
#else
	extern bool ParseEngine_Linux();
	bool FindSymbol(void* hlib, const char* sName, uint32_t* pSym);
	extern Host_Speeds_proto Host_Speeds_func;
#endif


