#include "osconfig.h"
#include <extdll.h>			// always
#include <meta_api.h>		// of course
#include "sdk_util.h"		// UTIL_LogPrintf, LCPrintf, etc
#include "dynpatcher_base.h"
#include "mmtimer.h"
#include "HookTools.h"

generic_dlldata_t GenericEngineData; //keeps info about engine_*.so (sections, etc)
EngineData_t DSEngineData; //conatins all offsets/addrs required to patch
Host_Speeds_proto Host_Speeds_func;

/* cvars */
cvar_t cv_mm_insane = {"mm_insane", "0", FCVAR_EXTDLL, 0, NULL};
cvar_t *pcv_mm_insane;
cvar_t *pcv_host_speeds;
cvar_t *pcv_sys_ticrate;

void CDECL Host_Speeds_hooked(void* hspd) {
	if (pcv_host_speeds->string[0] == '0')
		return;
	Host_Speeds_func(hspd);
}

void CDECL Sys_Sleep_hooked() {
	if (pcv_mm_insane->string[0] == '0') {
		usleep(1000000.0 / (pcv_sys_ticrate->value + 2.0));
	} else {
		if (pcv_mm_insane->string[0] == '2') {
			pthread_yield();
		} else {
			return;
		}
	}

}


char MBuffer[32768];

const char* GetFileName(const char *fpath) {
	int sl = strlen(fpath);
	const char *cp = fpath + sl;
	while (size_t(cp) > size_t(fpath)) {
		if (*cp == '\\' || *cp == '/') {
			return cp+1;
		}
		cp--;
	}
	return cp;
}

void* LocateLib(const char* libname) {
	char fname[128];
	char linebuf[512];
	char clib[256];
	const char *clp;
	FILE *fl;
	int sl;
	void* RegStart;
	void* RegEnd;
	Dl_info dli;

	sprintf(fname, "/proc/%d/maps", getpid());
	fl = fopen(fname, "r");
	if (fl == NULL) {
		return NULL;
	}

	setbuffer(fl, MBuffer, sizeof(MBuffer));
	while (fgets(linebuf, sizeof(linebuf), fl)) {
		sl = sscanf(linebuf, "%x-%x %s %s %s %s %s", &RegStart, &RegEnd, fname, fname, fname, fname, clib);
		if (sl != 7) {
			continue;
		}

		if (dladdr(RegStart, &dli) == 0) {
			continue;
		}

		clp = GetFileName(dli.dli_fname);
		if (strcmp(libname, clp) == 0) {
			fclose(fl);
			return dli.dli_fbase;
		}
	}
	fclose(fl);
	return NULL;
}


bool FindSymbol(void* hlib, const char* sName, uint32_t* pSym) {
	uint32_t csym =(uint32_t) dlsym(hlib, sName);
	if (csym == 0) {
		LCPrintf(true, "[MMTIMER]: Cant Resolve '%s'\n", sName);
		return false;
	}
	*pSym = csym;
	return true;
}

bool patch_engine()
{
	void* lib;
	void* slib;
	int Sym;
	int i;
	bool ires = false;
	char* EngineFileName = NULL;
	char* EngineName = NULL;
	
	lib = LocateLib("engine_i686.so");
	if (lib == NULL) {
		lib = LocateLib("engine_amd.so");
		if (lib == NULL) {
			lib = LocateLib("engine_i486.so");
			if (lib == NULL) {
				LCPrintf(true, "[MMTIMER]: Cant locate engine_*.so\n");
				return false;
			} else {
				EngineName = "engine_i486.so";
				EngineFileName = "./engine_i486.so";
			}
		} else {
			EngineName = "engine_amd.so";
			EngineFileName = "./engine_amd.so";
		}
	} else {
		EngineName = "engine_i686.so";
		EngineFileName = "./engine_i686.so";
	}

	LCPrintf(false, "[MMTIMER]: %s found at %p\n", EngineName, lib);
	slib = dlopen(EngineFileName, RTLD_NOW);
	if (slib == NULL) {
		LCPrintf(true, "[MMTIMER]: Cant load '%s'\n", EngineFileName);
		return 0;
	}

	FILE *fl = fopen(EngineFileName, "rb");
	int EngineSize;
	void* EngineBuf;
	if (fl == NULL) {
		LCPrintf(true, "[MMTIMER]: Failed to open '%s' for read\n", EngineFileName);
		return 0;
	}

	fseek(fl, 0, SEEK_END);
	EngineSize = ftell(fl);
	fseek(fl, 0, SEEK_SET);

	if (EngineSize < 0)
		EngineSize = 0;
	EngineBuf = malloc(EngineSize + 4);
	fread(EngineBuf, 1, EngineSize, fl);

	fclose(fl);

	if (!ParseGenericDllData_ELF(lib, EngineBuf, EngineSize, &GenericEngineData)) {
		free(EngineBuf);
		LCPrintf(true, "[MMTIMER]: Failed to parse generic ELF data\n");
		return false;
	}

	DSEngineData.hLib = slib;
	DSEngineData.libBase = lib;

	if (!ParseEngine_Linux()) {
		free(EngineBuf);
		LCPrintf(true, "[MMTIMER]: Failed to parse %s\n", EngineName);
		return false;
	}

	HookWord( (uint16_t*) DSEngineData.FilterTime_NopsAddr, 0xD8DD);
	HookFunction((void*) DSEngineData.Sys_Sleep_addr, (void*) &Sys_Sleep_hooked);
	memcpy(&Host_Speeds_func, &DSEngineData.Host_Speeds_addr, 4);
	HookFunction((void*) DSEngineData.Host_Speeds_jaddr, (void*) &Host_Speeds_hooked);



	free(EngineBuf);
	return true;
}

bool patch()
{
	if (!patch_engine())
		return false;

	return true;
}

bool mmtimer_init()
{
	if (!patch())
		return false;

	g_engfuncs.pfnCvar_RegisterVariable(&cv_mm_insane);
	pcv_mm_insane = g_engfuncs.pfnCVarGetPointer("mm_insane");
	if (pcv_mm_insane == NULL) {
		LCPrintf(true, "[MMTIMER]: failed to initialize mm_insane cvar\n");
		return false;
	}

	pcv_host_speeds = g_engfuncs.pfnCVarGetPointer("host_speeds");
	if (pcv_host_speeds == NULL) {
		LCPrintf(true, "[MMTIMER]: failed to initialize host_speeds cvar\n");
		return false;
	}

	pcv_sys_ticrate	= g_engfuncs.pfnCVarGetPointer("sys_ticrate");
	if (pcv_sys_ticrate	== NULL) {
		LCPrintf(true, "[MMTIMER]: failed to initialize sys_ticrate cvar\n");
		return false;
	}


	return true;
}

void mmtimer_end()
{
}
