#include "osconfig.h"
#include "mmtimer.h"
#include "dynpatcher_base.h"


bool ParseEngine_Linux() {
	uint32_t coderef_addr;
	uint32_t coderef2_addr;
	uint32_t FilterTime_addr;
	uint32_t tmp;
	bool bIsOk;

	/* Get Host_FilterTime() function address */
	if (!FindSymbol(DSEngineData.hLib, "Host_FilterTime", &FilterTime_addr)) {
		LCPrintf(true, "[MMTIMER]: %s: Unable to find Host_FilterTime() function\n", __FUNCTION__);
		return false;
	}

	/* Search forward for "fld [ebx-xxxx]" instruction
		DD83 ???????? fld [ebx-d_0_001]
	*/

	const char ScanData[] = "\xDD\x83\x00\x00\x00\x00";
	const char ScanMask[] = "\xFF\xFF\x00\x00\x00\x00";
	bIsOk = false;
	coderef_addr = FilterTime_addr;
	coderef_addr = Dll_ScanForTemplate_Forward(&GenericEngineData, (unsigned char*) ScanData,(unsigned char*) ScanMask, sizeof(ScanMask) - 1, coderef_addr, 0x500);
	while (coderef_addr && (coderef_addr - FilterTime_addr) < 0x500) {
		tmp = GenericEngineData.GlobalsBase + *((uint32_t*) (coderef_addr + 2));
		if (IsRangeInSections(GenericEngineData.vdata, tmp, 8)) {
			uint32_t *ptmp1 = (uint32_t*) tmp;
			uint32_t *ptmp2 = (uint32_t*) (tmp + 4);
			//FC A9 F1 D2 4D 62 50 3F
			//LCPrintf(false, "[MMTIMER]: %s: dw found at 0x%.8X (0x%.8X): %.8X %.8X\n", __FUNCTION__, tmp, (tmp - (uint32_t)DSEngineData.libBase), *ptmp1, *ptmp2);
			if (*ptmp1 == 0xD2F1A9FC && *ptmp2 == 0x3F50624D) {
				bIsOk = true;
				break;
			}

		}
		coderef_addr = Dll_ScanForTemplate_Forward(&GenericEngineData, (unsigned char*) ScanData,(unsigned char*) ScanMask, sizeof(ScanMask) - 1, coderef_addr+1, 0x500);
	}
	
	if (!bIsOk) {
		LCPrintf(true, "[MMTIMER]: %s: Unable to analyze Host_FilterTime() function (1)\n", __FUNCTION__);
		return false;
	}

	/* Search forward for "fstp qword ptr [ecx]" instruction */
	const char ScanData2[] = "\xDD\x19";
	const char ScanMask2[] = "\xFF\xFF";
	coderef_addr = Dll_ScanForTemplate_Forward(&GenericEngineData, (unsigned char*) ScanData2,(unsigned char*) ScanMask2, sizeof(ScanMask2) - 1, coderef_addr+1, 0x30);
	if (coderef_addr == NULL) {
		LCPrintf(true, "[MMTIMER]: %s: Unable to analyze Host_FilterTime() function (2)\n", __FUNCTION__);
		return false;
	}

	DSEngineData.FilterTime_NopsAddr = coderef_addr;

	/* Get NET_Sleep_Timeout() pointer address */
	if (!FindSymbol(DSEngineData.hLib, "NET_Sleep_Timeout", &DSEngineData.Sys_Sleep_addr)) {
		LCPrintf(true, "[MMTIMER]: %s: Unable to find NET_Sleep_Timeout() function\n", __FUNCTION__);
		return false;
	}

	if (!FindSymbol(DSEngineData.hLib, "Host_Speeds", &DSEngineData.Host_Speeds_addr)) {
		LCPrintf(true, "[MMTIMER]: %s: Unable to find Host_Speeds() function\n", __FUNCTION__);
		return false;
	}

	if (!Dll_FindJumpToFunc(&GenericEngineData, DSEngineData.Host_Speeds_addr, NULL, &DSEngineData.Host_Speeds_jaddr)) {
		LCPrintf(true, "[MMTIMER]: %s: Unable to find jump to Host_Speeds() function\n", __FUNCTION__);
		return false;
	}


	return true;
}