#include "osconfig.h"
#include <extdll.h>			// always
#include <meta_api.h>		// of course
#include "sdk_util.h"		// UTIL_LogPrintf, LCPrintf, etc
#include "dynpatcher_base.h"
#include "mmtimer.h"
#include "HookTools.h"

generic_dlldata_t GenericEngineData; //keeps info about swds.dll (sections, etc)
generic_dlldata_t GenericHLDSData; //keeps info about hlds.exe (sections, etc)
EngineData_t DSEngineData; //conatins all offsets/addrs required to patch

NtDelayExecution_proto NtDelayExecution_func;

// Vars for mmtimer setting
UINT wTimerRes;
bool timePeriodStarted = false;


/* cvars */
cvar_t cv_mm_insane = {"mm_insane", "0", FCVAR_EXTDLL, 0, NULL};
cvar_t *pcv_mm_insane;

void WINAPI Sleep_hooked(DWORD ms, uint32_t call_addr) {
	LARGE_INTEGER itv;
	if (ms == 1 && call_addr > GenericHLDSData.code.start && call_addr < GenericHLDSData.code.end) {
		if (pcv_mm_insane->string[0] == '0') {
			itv.QuadPart = (-10);
			NtDelayExecution_func(FALSE, &itv);
		} else {
			if (pcv_mm_insane->string[0] == '2') {
				SwitchToThread();
			} else {
				return;
			}
		}
	} else {
		itv.QuadPart = ms;
		itv.QuadPart *= -10000;
		NtDelayExecution_func(FALSE, &itv);
	}
}

void __declspec(naked) Sleep_AsmHelper() {
	__asm {
		mov ecx, [esp+4]
		mov eax, [esp]
		push eax
		push ecx
		call Sleep_hooked
		retn 4
	}
}

bool patch()
{
	// We need swds.dll load address
	void* dbase = GetModuleHandleW(L"swds.dll");
	if (dbase == NULL) {
		LCPrintf(true, "[MMTIMER]: Failed to locate swds.dll\n");
		return false;
	}
	LCPrintf(false, "[MMTIMER]: Found swds.dll at 0x%.8X\n", dbase);

	void* pHLDS = GetModuleHandleW(L"hlds.exe");
	if (pHLDS == NULL) {
		LCPrintf(true, "[MMTIMER]: Failed to locate hlds.exe\n");
		return false;
	}
	LCPrintf(false, "[MMTIMER]: Found hlds.exe at 0x%.8X\n", pHLDS);

	// prepare generic swds.dll data
	if (!ParseGenericDllData_PE(dbase, &GenericEngineData)) {
		LCPrintf(true, "[MMTIMER]: Failed to parse swds.dll (1)\n");
		return false;
	}

	// prepare generic hlds.exe data
	if (!ParseGenericDllData_PE(pHLDS, &GenericHLDSData)) {
		LCPrintf(true, "[MMTIMER]: Failed to parse hlds.exe\n");
		return false;
	}

	if (!ParseEngine_Win()) {
		LCPrintf(true, "[MMTIMER]: Failed to parse swds.dll (2)\n");
		return false;
	}

	// setup function pointers
	memcpy(&NtDelayExecution_func, &DSEngineData.NtDelayExecution_addr, 4);

	// Perform patching
	HookFunction( (void*) DSEngineData.Sleep_addr, (void*) &Sleep_AsmHelper);
	
	if (DSEngineData.Limit1000FPS_haddr)
		HookFunction( (void*) DSEngineData.Limit1000FPS_haddr, (void*) DSEngineData.Limit1000FPS_JumpAddr);

	return true;
}

bool mmtimer_init()
{
	TIMECAPS tc;

	if (timeGetDevCaps(&tc, sizeof(TIMECAPS)) != TIMERR_NOERROR)
	{
		LCPrintf(true, "[MMTIMER]: timeGetDevCaps() failed\n");
		return(FALSE);
	}

	// Set higher timer resolution.
	wTimerRes = min(max(tc.wPeriodMin, 1), tc.wPeriodMax);
	timeBeginPeriod(wTimerRes);
	timePeriodStarted = true;

	if (!patch())
		return false;

	g_engfuncs.pfnCvar_RegisterVariable(&cv_mm_insane);
	pcv_mm_insane = g_engfuncs.pfnCVarGetPointer("mm_insane");
	if (pcv_mm_insane == NULL) {
		LCPrintf(true, "[MMTIMER]: failed to initialize mm_insane cvar\n");
		return false;
	}
	return true;
}

void mmtimer_end()
{
	// End high resolution timer.
	if (timePeriodStarted)
		timeEndPeriod(wTimerRes);
}
