# MySQL file for AMXMD's Stats
# --------------------------------------------------------

#
# Table structure for table `amx_match_main`
#
# half1 = half1; half2 = half2; half3 = ot1; half4 = ot2
# map2: half5 = half1; half6 = half2; half7 = ot1; half8 = ot2
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_main` (
  `match_id` int(10) NOT NULL auto_increment,
  `map1_id` int(10) NOT NULL default '-1',
  `map2_id` int(10) NOT NULL default '-1',  
  `half1_id` int(10) NOT NULL default '-1',
  `half2_id` int(10) NOT NULL default '-1',
  `half3_id` int(10) NOT NULL default '-1',
  `half4_id` int(10) NOT NULL default '-1',
  `half5_id` int(10) NOT NULL default '-1',
  `half6_id` int(10) NOT NULL default '-1',
  `half7_id` int(10) NOT NULL default '-1',
  `half8_id` int(10) NOT NULL default '-1',
  PRIMARY KEY  (`match_id`)
) TYPE=MyISAM;

# --------------------------------------------------------


#
# Table structure for table `amx_match_half`
#
# team1 -> T
# team2 -> CT
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_half` (
  `half_id` int(10) NOT NULL auto_increment,
  `team1_id` int(10) NOT NULL default '-1',
  `team1_score` int(4) NOT NULL default '0',
  `team2_id` int(10) NOT NULL default '-1',
  `team2_score` int(4) NOT NULL default '0',
  PRIMARY KEY  (`half_id`)
) TYPE=MyISAM;

# --------------------------------------------------------


#
# Table structure for table `amx_match_map`
#
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_map` (
  `map_id` int(10) NOT NULL auto_increment,
  `map_name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`map_id`)
) TYPE=MyISAM;

# --------------------------------------------------------


#
# Table structure for table `amx_match_player`
#
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_player` (
  `player_id` int(10) NOT NULL auto_increment,
  `player_steamid` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`player_id`)
) TYPE=MyISAM;

# --------------------------------------------------------


#
# Table structure for table `amx_match_player_name`
#
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_player_name` (
  `name_id` int(10) NOT NULL auto_increment,
  `player_id` int(10) NOT NULL default '-1',
  `player_name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`name_id`)
) TYPE=MyISAM;

# --------------------------------------------------------


#
# Table structure for table `amx_match_player_statistics`
#
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_player_statistics` (
  `statistics_id` int(10) NOT NULL auto_increment,
  `player_id` int(10) NOT NULL default '-1',
  `half_id` int(10) NOT NULL default '-1',
  `player_frags` int(4) NOT NULL default '0',
  `player_deaths` int(4) NOT NULL default '0',
  `team_id` int(10) NOT NULL default '-1',
  PRIMARY KEY  (`statistics_id`)
) TYPE=MyISAM;

# --------------------------------------------------------


#
# Table structure for table `amx_match_team`
# --------------------------------------------------------
#

CREATE TABLE IF NOT EXISTS `amx_match_team` (
  `team_id` int(10) NOT NULL auto_increment,
  `team_name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`team_id`)
) TYPE=MyISAM;

# --------------------------------------------------------