/*	Formatright  2010, ConnorMcLeod

	Team Flash Punish is free software;
	you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Team Flash Punish; if not, write to the
	Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	Boston, MA 02111-1307, USA.
*/

#include <amxmodx>
#include <cstrike>
#include <fakemeta>
#include <hamsandwich>

new const VERSION[] = "1.1.0"

const MAX_PLAYERS = 32

new g_iMaxPlayers
#define IsPlayer(%1)	( 1 <= %1 <= g_iMaxPlayers )

const MAX_ENTSARRAYS_SIZE = 64

new g_bitGonnaExplode[MAX_ENTSARRAYS_SIZE]
#define SetGrenadeExplode(%1)		g_bitGonnaExplode[%1>>5] |=  1<<(%1 & 31)
#define ClearGrenadeExplode(%1)	g_bitGonnaExplode[%1>>5] &= ~( 1 << (%1 & 31) )
#define WillGrenadeExplode(%1)	g_bitGonnaExplode[%1>>5] &   1<<(%1 & 31)

const XTRA_OFS_PLAYER = 5

enum ( <<= 1 ) {
	CountSemiFlash = 1,
	CountFullFlash,
	CountDeadFlasher
}

enum ( <<= 1 ) {
	PunishHealth = 1,
	PunishMoney
}

new Float:g_flCurrentGameTime, g_iCurrentFlasher

new g_iFlashTeamCount[MAX_PLAYERS+1]

new g_pcvarTeamFlash, g_pcvarMax, g_pcvarHealth, g_pcvarPunish, g_pcvarMoney

new g_iHudTextArgs, g_iTextMsg

public plugin_init()
{
	register_plugin("Team Flash Punish", VERSION, "ConnorMcLeod")

	g_pcvarTeamFlash = register_cvar("tfp_count", "3")	// Additive values 0: don't count, 1:count semi flash, 2:count full flash, 4:count dead flasher
	g_pcvarMax = register_cvar("tfp_max_count", "10")		// disallow flashbang after X count
	g_pcvarPunish = register_cvar("tfp_punish", "2")		// Additive values 0: don't punish, 1:health, 2:money
	g_pcvarHealth = register_cvar("tfp_health_amount", "5")	// health reduction
	g_pcvarMoney = register_cvar("tfp_money_amount", "200")	// cash taken

	register_event("ScreenFade", "Event_ScreenFade", "be", "4=255", "5=255", "6=255", "7=200", "7=255")

	RegisterHam(Ham_Think, "grenade", "Ham__CGrenade_Think__Pre")

	RegisterHam(Ham_Touch, "armoury_entity", "CArmouryEntity_Touch")
	RegisterHam(Ham_Touch, "weaponbox", "CWeaponBox_Touch")

	register_clcmd("menuselect 3", "ClientCommand_MenuSelect_3")

	g_iMaxPlayers = get_maxplayers()
	g_iHudTextArgs = get_user_msgid("HudTextArgs")
	g_iTextMsg = get_user_msgid("TextMsg")
}

public client_putinserver(id)
{
	g_iFlashTeamCount[id] = 0
}

CantBuyFlashBang(id)
{
	if( CantHaveFlashbangsAnymore(id) && cs_get_user_buyzone(id) )
	{
		message_begin(MSG_ONE, g_iTextMsg, .player=id)
		{
			write_byte(4)
			write_string("#Weapon_Not_Available")
		}
		message_end()
		return PLUGIN_HANDLED
	}	
	return PLUGIN_CONTINUE
}

CantHaveFlashbangsAnymore(id)
{
	new iMax = get_pcvar_num(g_pcvarMax)
	return (iMax && g_iFlashTeamCount[id] >= iMax)
}

public ClientCommand_MenuSelect_3( id )
{
	const m_iMenuIndex = 205
	const EQUIP_MENU = 10
	if(	is_user_alive(id)
	&&	get_pdata_int(id, m_iMenuIndex, XTRA_OFS_PLAYER) == EQUIP_MENU
	&&	cs_get_user_buyzone(id)
	&&	cs_get_user_money(id) >= 200 )
	{
		return CantBuyFlashBang(id)
	}
	return PLUGIN_CONTINUE
}

public client_command( id )
{
	new szCommand[7]
	const FLASH_BUYALIAS_STRLEN = 5
	if( read_argv(0, szCommand, charsmax(szCommand)) == FLASH_BUYALIAS_STRLEN && equal(szCommand, "flash") )
	{
		return CantBuyFlashBang(id)
	}
	return PLUGIN_CONTINUE
}

public Cs_InternalCommand( id, szCommand[] )
{
	if( equal(szCommand, "flash") )
	{
		return CantBuyFlashBang(id)
	}
	return PLUGIN_CONTINUE
}

public Ham__CGrenade_Think__Pre( iEnt )
{
	static Float:flGameTime, Float:flDmgTime, iOwner
	flGameTime = get_gametime()
	pev(iEnt, pev_dmgtime, flDmgTime)
	const XTRA_OFS_GRENADE = 5
	if(	flDmgTime <= flGameTime

	// VEN's way on how to detect grenade type
	// http://forums.alliedmods.net/showthread.php?p=401189#post401189
	&&	get_pdata_int(iEnt, 114, XTRA_OFS_GRENADE) == 0 // has a bit when is HE or SMOKE
	&&	!(get_pdata_int(iEnt, 96, XTRA_OFS_GRENADE) & (1<<8)) // has this bit when is c4

	&&	IsPlayer( (iOwner = pev(iEnt, pev_owner)) )	) // if no owner (3rd 'after dmgtime' frame), grenade gonna be removed from world
	{
		if( ~WillGrenadeExplode(iEnt) ) // grenade gonna explode on next think
		{
			SetGrenadeExplode( iEnt )
		}
		else
		{
			ClearGrenadeExplode( iEnt )
			g_flCurrentGameTime = flGameTime
			g_iCurrentFlasher = iOwner
		}
	}
}

public Event_ScreenFade(id)
{
	new Float:flGameTime = get_gametime()
	if(	id != g_iCurrentFlasher
	&&	g_flCurrentGameTime == flGameTime
	&&	cs_get_user_team(id) == cs_get_user_team(g_iCurrentFlasher)	)
	{		
		new bool:bFullFlashed = ( read_data(7) == 255 )
		new bAlive = is_user_alive(g_iCurrentFlasher)

		new iCountType = get_pcvar_num(g_pcvarTeamFlash)
		if( iCountType && (iCountType & CountDeadFlasher || bAlive) )
		{
			if(	(iCountType & CountFullFlash && bFullFlashed == bFullFlashed)
			||	iCountType & CountSemiFlash	)
			{
				g_iFlashTeamCount[g_iCurrentFlasher]++
				new iPunish = get_pcvar_num(g_pcvarPunish)
				if( iPunish & PunishHealth && bAlive )
				{
					new Float:flHealth
					pev(g_iCurrentFlasher, pev_health, flHealth)
					flHealth -= get_pcvar_float(g_pcvarHealth)
					if( flHealth < 1.0 )
					{
						flHealth = 1.0
					}
					set_pev(g_iCurrentFlasher, pev_health, flHealth)
				}
				if( iPunish & PunishMoney )
				{
					new iMoney = max(cs_get_user_money(g_iCurrentFlasher) - get_pcvar_num(g_pcvarMoney), 0)
					cs_set_user_money(g_iCurrentFlasher, iMoney, 1)
				}
			}
		}

		const m_flNextHudTextArgsGameTime = 198
		if( get_pdata_float(id, m_flNextHudTextArgsGameTime, XTRA_OFS_PLAYER) < flGameTime )
		{
			set_pdata_float(id, m_flNextHudTextArgsGameTime, flGameTime + 5.0, XTRA_OFS_PLAYER)

			message_begin(MSG_ONE, g_iHudTextArgs, .player=g_iCurrentFlasher)
			{
				write_string("#Hint_try_not_to_injure_teammates")
				write_byte(1)
				write_byte(0)
			}
			message_end()
		}
	}
}

public CArmouryEntity_Touch(iArmoury, id)
{
	const XTRA_OFS_ARMOURY = 4
	const m_iItem = 34
	const CSA_FLASHBANG = 14
	if( IsPlayer(id) && get_pdata_int(iArmoury, m_iItem, XTRA_OFS_ARMOURY) == CSA_FLASHBANG && CantHaveFlashbangsAnymore(id) )
	{
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

public CWeaponBox_Touch(iWeaponBox, id)
{
	if( IsPlayer(id) )
	{
		const XTRA_OFS_WEAPONBOX = 4
		const m_rgpPlayerItems_slot4 = 38
		new iWeapon = get_pdata_cbase(iWeaponBox, m_rgpPlayerItems_slot4, XTRA_OFS_WEAPONBOX)
		if( iWeapon > 0 && cs_get_weapon_id(iWeapon) == CSW_FLASHBANG && CantHaveFlashbangsAnymore(id) )
		{
			return HAM_SUPERCEDE
		}
	}
	return HAM_IGNORED
}