/*
	v0.1 - v0.1c [02.08.2011] - first release + code fix
	v0.2 [04.08.2011] - added lie flat
	v0.3 [26.08.2011] (+KORD_12.7 optimizations) - 1)added reflect damage, 2)added sounds, 3)removed cvar "spin", 4)fixed cvar "jump"
	v0.4 [17.10.2011] 1)removed sound cvar 2)added shoot reaction 3)optimizations
	v0.4a [23.10.2011] 1)Added wp reflect avel
	v0.4b [08.11.2011] 1)added new sounds 2)more realistic now 3)added sparks
	v0.4b1 [09.11.2011] 1)added macros on SOUNDS 2)fixed sparks macros 3)added macros DEBUG
	v0.4b2 [17.11.2011] 1)fixed grenades! in cstrike :D 2)added functionality
	v0.4b3 [21.11.2011] 1)fixed stuck bug 2)fixed class registration in hl 3)physics now MORE REAL :D 4)added grenade shoot in cs/csz

	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community

	Code has taken from "Weapon_Physics" & "Lie_Flat" by author "Nomexous"
*/

#include <amxmodx>
#include <hamsandwich>
#include <fakemeta_util>

/* <<< OPTIONS >>> */

//#define Half_Life 	// comment this to enable for cstrike !
#define NEW_SOUNDS	// if defined, new sound will be activated

/* BLOCK PLUGIN ADDONS (if comment - addons will be blocked) */

//#define SPARKS_ON		// enable/disable - Sparks. If SHOOTS_ON is comment - it will be blocked. Sparks NOT recommended!
//#define DEBUG_ON		// messages enable (in server console), like - >> HAMSANDWICH: hl_weapon_physics: `weaponbox` <<
#define SOUNDS_ON		// enable sounds
#define SHOOTS_ON		// enable shoot reaction/ Not work with out TAKE_DAMAGE cvar
#define SHOOT_GRENADES_ON	// (CS/CSZ) enable grenades shooting (SHOOTS_ON - must be defined!)
#define TRAILS_ON		// enable trails
#define RENDERING_ON		// enable rendering
#define WEAPON_THROWING_ON	// enable weapon throwing (RECOMMENDED! :D)
	
/* END BLOCKS */

/* Options with - (*) are tested & not recommended change them */

const UNSTUCK = 0		// (*) num repeats to start blocking stuck bug #(Default: 0)#
const PUNCH_POWER = 32		// (*) power that do to stack items #(Default: 32)#
const AMXMODX_PATH = 128		// amxmodx path max len
const PRESS_BUTTON = IN_USE	// button to enable throwing. May be - (IN_USE | IN_ATTACK | IN_FORWARD) ... :)
const ADMIN = ADMIN_IMMUNITY	// admin flags for clcmd command in DEBUG mode (block class)

const Float:REDUCE = 0.32		// (*) reduce jump power #(Default: 0.32)#
const Float:GRAVITY = 1.92	// (*) gravity for phisics items, 1.5 - means normal gravity: 800 * 1.5 #(Default 1.92)#
const Float:SOUND_HIT = 0.5	// volume
const Float:SOUND_TOUCH = 0.25	// volume
const Float:ANGLES_REGRESS = 0.64 // (*) avel slowdown #(Default: 0.64)#

#if defined TRAILS_ON
new const SPRITE[] = "sprites/arrow1.spr" 	// trail sprite
#endif
#if defined DEBUG_ON
new const CL_CMD_COMMAND[] = "block_class"	// clcmd command to block wp class. Example: block_class weaponbox. In DEBUG mode only!
#endif

/* <<< END OPTIONS >>> */

#define HL_SHOOT(%1) 1 << %1 & g_cvars[EVENT_SHOOT_HL]
#define CS_SHOOT(%1) 1 << %1 & ~g_cvars[EVENT_SHOOT_CS]

enum _:GLOBAL_COORDS
{
	X_AXIS,
	Y_AXIS,
	Z_AXIS
}

enum _:GLOBAL_COORDS_FLOAT
{
	Float:X_AXIS_FLOAT,
	Float:Y_AXIS_FLOAT,
	Float:Z_AXIS_FLOAT
}

enum _:CS_EVENTS
{
	AWP = 1,
	G3SG1,
	AK47,
	SCOUT,
	M249,
	M4A1,
	SG552,
	AUG,
	SG550,
	M3,
	XM1014,
	USP,
	MAC10,
	UMP45,
	FIVESEVEN,
	P90,
	DEAGLE,
	P228,
	UNKNOWN_1, 	// ??? unkown
	GLOCK18,
	MP5NAVY,
	TMP,
	ELITE_RIGHT,
	ELITE_LEFT,
	UNKNOWN_2, 	// ??? unkown
	SMOKE_PUFF,
	GALIL,
	FAMAS,
	PLAYER_SPAWN
}

enum _:HL_EVENTS
{
	SHOTGUN_PRIM = 1,
	SHOTGUN_SEC,
	CROWBAR, 	// prim
	GLOCK_PRIM,
	GLOCK_SEC,
	MP5_PRIM,
	MP5_SEC,
	PYTHON,
	GAUSS_PRIM,	// need ckeck weapon !
	GAUSS_SEC,	// in spin
	RPG,
	CROSSBOW_PRIM,
	CROSSBOW_SEC,
	EGON_PRIM,
	EGON_SEC,	// need check weapon !
	TRIPMINE,
	SNARK,
	HORNETGUN
	
	// no events for: displancer, hand_grenade, satchel !
}

enum _:TOUCH_FLOATS
{
	VELOCITY,
	ORIGIN,
	ANGLES,
	TRACE_TO,
	RIGHT,
	UP,
	FWD,
	ANGLES_2,
	VECTOR,
	CHANGE_A_VEL
}

enum _:BOX_CHECK
{
	BOX_INDEX,
	BOX_STUCK_TIMES,
	BLOCK_BUG
}

enum _:PLUGIN_CVARS
{
#if defined TRAILS_ON
	TRAIL_SPRITE,
	TRAIL,
#endif
#if defined RENDERING_ON	
	RENDERING,
#endif
	MAX_PLAYERS,
#if defined SHOOTS_ON || (defined SHOOT_GRENADES_ON && !defined Half_Life)
	SHOOT,
#endif	
#if defined WEAPON_THROWING_ON	
	THROWING,
#endif
#if !defined Half_Life	
	EVENT_SHOOT_CS,
#endif
#if defined Half_Life	
	EVENT_SHOOT_HL,
#endif	
	DAMAGE
}

new
g_config_path[AMXMODX_PATH],
g_cvars[PLUGIN_CVARS],
Trie:g_trie_string

#define PLUGIN  "hl_weapon_physics"
#define VERSION "0.4b3"
#define AUTHOR  "Turanga_Leela"

#if defined SOUNDS_ON
new const wp_sounds[][] =
{
#if !defined NEW_SOUNDS
	"debris/metal6.wav",
	"items/weapondrop1.wav"
#endif
#if defined NEW_SOUNDS
	"misc/wp_bullet1.wav",
	"misc/wp_bullet2.wav",
	"misc/wp_bullet3.wav",
	"misc/wp_bullet4.wav",
	
	"misc/wp_touch1.wav",
	"misc/wp_touch2.wav",
	"misc/wp_touch3.wav"
#endif
}
#endif

set_a_velocity(ent, Float:velocity[])
{
	set_pev(ent, pev_avelocity, velocity)	
}

check_pev(ent, pev_is)
{	
	return pev(ent, pev_is)
}

check_valid(ent)
{
	return pev_valid(ent)
}

#if defined DEBUG_ON
public block(id)
{
	new command[32]
	read_argv(id, command, charsmax(command))
	
	client_print(id, print_chat, "Class Blocked!: %s", command)
	change_config(command)
}	
#endif

#if defined TRAILS_ON
ent_trail(ent)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)		
	write_byte(TE_BEAMFOLLOW)  
	write_short(ent)
	write_short(g_cvars[TRAIL_SPRITE])
	write_byte(5)
	write_byte(2)
	write_byte(random(256))
	write_byte(random(256))
	write_byte(random(256))
	write_byte(255)		
	message_end()
}
#endif

#if defined SOUNDS_ON
emit_sound_func(ent, Float:value, mode)
{
#if !defined NEW_SOUNDS
	engfunc(EngFunc_EmitSound, ent, CHAN_AUTO, wp_sounds[mode ? 1: 0], value, ATTN_NORM, 0, PITCH_NORM)
#endif
#if defined NEW_SOUNDS
	engfunc(EngFunc_EmitSound, ent, CHAN_AUTO, wp_sounds[mode ? random_num(4, 6): random(4)], value, ATTN_NORM, 0, PITCH_NORM)
#endif	
}
#endif

#if defined Half_Life
public plugin_init()
{		
	g_cvars[MAX_PLAYERS] = get_maxplayers()
	g_cvars[EVENT_SHOOT_HL] |= (1 << SHOTGUN_PRIM | 1 << SHOTGUN_SEC | 1 << GLOCK_PRIM | 1 << GLOCK_SEC | 1 << MP5_PRIM | 1 << PYTHON | 1 << CROSSBOW_SEC/* | 1 << GAUSS_PRIM | 1 << EGON_PRIM*/)
	
#if defined WEAPON_THROWING_ON	
	g_cvars[THROWING] = register_cvar("hl_physics_throw", "1")
#endif
#if defined RENDERING_ON	
	g_cvars[RENDERING] = register_cvar("hl_physics_rendering", "3")
#endif
#if defined SHOOTS_ON // || defined SHOOT_GRENADES_ON
	g_cvars[SHOOT] = register_cvar("hl_physics_shoot", "1")
#endif			
	g_cvars[DAMAGE] = register_cvar("hl_physics_damage", "1")
	g_trie_string = TrieCreate()
	
	check_config()

	register_plugin(PLUGIN, VERSION, AUTHOR)
#if defined DEBUG_ON	
	register_clcmd(CL_CMD_COMMAND, "block", ADMIN)
#endif
	register_forward(FM_SetModel, "fm_set_model_post", 1)	
#if defined SHOOTS_ON // || defined SHOOT_GRENADES_ON 	
	register_forward(FM_PlaybackEvent, "fm_play_back_event_post", 1)
#endif
}
#endif

//#if defined Half_Life && (defined SOUNDS_ON || defined TRAILS_ON) || !defined Half_Life
#if defined Half_Life && defined TRAILS_ON || !defined Half_Life || defined SOUNDS_ON
public plugin_precache()
{
#if defined TRAILS_ON
	g_cvars[TRAIL_SPRITE] = precache_model(SPRITE)
	g_cvars[TRAIL] = register_cvar("hl_physics_trails", "3")
#endif	
#if defined SOUNDS_ON
	for(new i; i < sizeof wp_sounds; i++)
		precache_sound(wp_sounds[i])
#endif	
#if !defined Half_Life
#if defined RENDERING_ON	
	g_cvars[RENDERING] = register_cvar("hl_physics_rendering", "3")
#endif
#if defined WEAPON_THROWING_ON	
	g_cvars[THROWING] = register_cvar("hl_physics_throw", "1")
#endif
#if defined SHOOTS_ON || defined SHOOT_GRENADES_ON
	g_cvars[SHOOT] = register_cvar("hl_physics_shoot", "1")
#endif			
	g_cvars[MAX_PLAYERS] = get_maxplayers()
	g_cvars[EVENT_SHOOT_CS] |= (1 << UNKNOWN_1 | 1 << UNKNOWN_2 | 1 << SMOKE_PUFF)
	g_cvars[DAMAGE] = register_cvar("hl_physics_damage", "1")
	g_trie_string = TrieCreate()
	
	check_config()

	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_forward(FM_SetModel, "fm_set_model_post", 1)
	
#if defined SHOOTS_ON || defined SHOOT_GRENADES_ON
	register_forward(FM_PlaybackEvent, "fm_play_back_event_post", 1)
#endif	
	
#if defined DEBUG_ON	
	register_clcmd(CL_CMD_COMMAND, "block", ADMIN)
#endif
#endif	
}
#endif
	
change_config(ent_class[])
{
	new config = fopen(g_config_path, "a"), blocked_class[32], line, line_len
	
	if(ent_class[0] && config)
	{
		fprintf(config, "%s%s", "^n", ent_class)
		fclose(config)		
	}
		
	while(read_file(g_config_path, line++, blocked_class, charsmax(blocked_class), line_len))
	{
		if(!line_len || equali(blocked_class, "//", 2) || TrieKeyExists(g_trie_string, blocked_class)) continue		
		TrieSetString(g_trie_string, blocked_class, "blocked")		
	}
	
	fclose(config)	
}
	
check_config()
{
	get_localinfo("amxx_configsdir", g_config_path, charsmax(g_config_path))
	formatex(g_config_path, charsmax(g_config_path), "%s/%s%s", g_config_path, PLUGIN, ".ini")
		
	if(!file_exists(g_config_path))
	{
		write_file(g_config_path, "// Print bellow blocked classes", -1)
#if !defined Half_Life 		
		change_config("grenade")
#endif		
		return
	}
	
	change_config("")
}	

#if defined SHOOTS_ON || (defined SHOOT_GRENADES_ON && !defined Half_Life) 
public fm_play_back_event_post(flags, id, eventid)
{	
#if !defined Half_Life
#if defined SHOOT_GRENADES_ON && !defined SHOOTS_ON
	if(eventid < 29 && CS_SHOOT(eventid) && get_pcvar_num(g_cvars[SHOOT]))
#endif
#if !defined SHOOT_GRENADES_ON || (defined SHOOT_GRENADES_ON && defined SHOOTS_ON)
	if(eventid < 29 && CS_SHOOT(eventid) && get_pcvar_num(g_cvars[SHOOT]) && get_pcvar_num(g_cvars[DAMAGE]))
#endif	
#endif	

#if defined Half_Life	
/*
#if defined SHOOT_GRENADES_ON && !defined SHOOTS_ON
	if(eventid < 14 && HL_SHOOT(eventid) && get_pcvar_num(g_cvars[SHOOT]))
#endif
#if !defined SHOOT_GRENADES_ON || (defined SHOOT_GRENADES_ON && defined SHOOTS_ON)	
	if(eventid < 14 && HL_SHOOT(eventid) && get_pcvar_num(g_cvars[SHOOT]) && get_pcvar_num(g_cvars[DAMAGE]))
#endif
*/	
	if(eventid < 14 && HL_SHOOT(eventid) && get_pcvar_num(g_cvars[SHOOT]) && get_pcvar_num(g_cvars[DAMAGE]))
#endif	
	{
		static Float:start_aim[GLOBAL_COORDS_FLOAT], Float:end_aim_f[GLOBAL_COORDS_FLOAT], end_aim[GLOBAL_COORDS], ent, trace, result
#if defined SHOOT_GRENADES_ON && !defined Half_Life
		,
		grenade_index
#endif
		pev(id, pev_origin, start_aim)
		get_user_origin(id, end_aim, 3)

		end_aim_f[X_AXIS_FLOAT] = float(end_aim[X_AXIS])
		end_aim_f[Y_AXIS_FLOAT] = float(end_aim[Y_AXIS])
		end_aim_f[Z_AXIS_FLOAT] = float(end_aim[Z_AXIS])
	
#if defined SHOOT_GRENADES_ON && !defined Half_Life		
		while((ent = fm_find_ent_by_class(ent, "grenade")))
		{
			if(ent != grenade_index)
			{
				engfunc(EngFunc_TraceModel, start_aim, end_aim_f, HULL_HEAD, ent, trace)
			
				if(check_valid(ent) && get_tr2(trace, TR_pHit) == ent)
				{				
					new name[32], grenade_id[16]
					result = 1 << get_pdata_int(ent, 114)
				
					if(result & (1 << 25)) grenade_id = "HEGrenade"
					else if(result & 1 && !get_pdata_int(ent, 96)) grenade_id = "FlashBang"
					else if(result & (1 << 26))
					{
						set_pev(ent, pev_flags, pev(ent, pev_flags) | FL_ONGROUND)
						grenade_id = "SmokeGrenade"
					}
					
					get_user_name(id, name, charsmax(name))	
		
					client_print(0, print_chat, "%s%s%s %s %s%s%s %s", "[", name, "]:", " HIT -", " `", grenade_id, "`", "O_o!")
		
					set_pev(ent, pev_dmgtime, 0.0)
					dllfunc(DLLFunc_Think, ent)
	
					grenade_index = ent
				
					break
				}
			}
		}		
#endif			
#if defined SHOOT_GRENADES_ON && defined SHOOTS_ON && !defined Half_Life	
		if(!get_pcvar_num(g_cvars[DAMAGE])) return
#endif			
#if defined SHOOTS_ON
		while((ent = engfunc(EngFunc_FindEntityInSphere, ent, end_aim_f, 10.0)))  	
		{
			if(check_pev(ent, pev_movetype) != MOVETYPE_BOUNCE || !check_valid(ent)/* || !(check_pev(ent, pev_flags) & FL_ONGROUND)*/) continue
			
			engfunc(EngFunc_TraceModel, start_aim, end_aim_f, HULL_POINT, ent, trace)
			result = get_tr2(trace, TR_pHit)
			
			if(result == ent)
			{
#if defined SPARKS_ON				
				continue_check(id, ent, eventid, end_aim)
#endif									
#if !defined SPARKS_ON		
				continue_check(id, ent, eventid)
#endif					
			}
			
			else if(result < 0) 
			{
				static Float:origin[GLOBAL_COORDS_FLOAT]
				pev(ent, pev_origin, origin)
				
				if(get_distance_f(origin, end_aim_f) > 2.5) continue	
#if defined SPARKS_ON				
				continue_check(id, ent, eventid, end_aim)
#endif									
#if !defined SPARKS_ON		
				continue_check(id, ent, eventid)
#endif					
			}
		}
#endif
	}
}
#endif

#if defined SHOOTS_ON
#if defined SPARKS_ON
continue_check(id, ent, weapon, origin[])
#endif
#if !defined SPARKS_ON
continue_check(id, ent, weapon)
#endif
{
#if defined SPARKS_ON				
/*
#if defined Half_Life				
	if(1 << weapon & ~(1 << GAUSS_PRIM | 1 << EGON_PRIM))
	{
#endif	
*/					
	message_begin(MSG_BROADCAST ,SVC_TEMPENTITY)
		
	write_byte(TE_SPARKS)
	write_coord(origin[X_AXIS])
	write_coord(origin[Y_AXIS])
	write_coord(origin[Z_AXIS] + 1) 
		
	message_end()
/*
#if defined Half_Life						
	}
#endif	
*/
#endif			
	static Float:damage
#if defined SOUNDS_ON		
	emit_sound_func(ent, SOUND_HIT, 0)
#endif					
	switch(weapon)
	{
#if !defined Half_Life
		case USP, ELITE_LEFT, ELITE_RIGHT, GLOCK18, FIVESEVEN, P228:	damage = 35.0
		case MAC10, TMP:                                                	damage = 40.0   
		case MP5NAVY, UMP45, P90:                              		damage = 50.0
		case DEAGLE, M3, XM1014:                          			damage = 60.0
		case M4A1, AK47, SG552, AUG, GALIL, FAMAS, M249:      		damage = 75.0
		case SCOUT, SG550, G3SG1:                                  		damage = 85.0
		case AWP:                                                          	damage = 100.0   
#endif	
#if defined Half_Life
		/*case EGON_PRIM:				damage = 25.0*/
		case GLOCK_PRIM, GLOCK_SEC:		damage = 35.0
		case MP5_PRIM: 				damage = 45.0   
		case PYTHON:				damage = 60.0
		case SHOTGUN_PRIM /*, GAUSS_PRIM*/:	damage = 75.0
		case CROSSBOW_SEC:			damage = 85.0
		case SHOTGUN_SEC:			damage = 100.0
#endif		
		default: return
	}

	ExecuteHamB(Ham_TakeDamage, ent, id, id, damage, DMG_BULLET)
}
#endif		

public ham_touch_post(ent, entTouched)
{
	if(check_valid(ent) && check_pev(entTouched, pev_solid) & SOLID_BSP)
	{
		static trace, Float:floats[TOUCH_FLOATS][GLOBAL_COORDS_FLOAT], box_stuck[BOX_CHECK]
		
		pev(ent, pev_velocity, floats[VELOCITY])
		xs_vec_mul_scalar(floats[VELOCITY], REDUCE, floats[VELOCITY])
		set_pev(ent, pev_velocity, floats[VELOCITY])
		
		pev(ent, pev_origin, floats[ORIGIN])
		
		xs_vec_sub(floats[ORIGIN], Float:{0.0, 0.0, 10.0}, floats[TRACE_TO])
		engfunc(EngFunc_TraceLine, floats[ORIGIN], floats[TRACE_TO], IGNORE_MONSTERS, ent, trace)
	
		get_tr2(trace, TR_vecPlaneNormal, floats[UP])

		if(!floats[UP][Z_AXIS_FLOAT]) return
		
		else if(((floats[VELOCITY][Y_AXIS_FLOAT] && floats[UP][Y_AXIS_FLOAT]) || (floats[VELOCITY][X_AXIS_FLOAT] && floats[UP][X_AXIS_FLOAT])) && (-2.0 < floats[VELOCITY][Z_AXIS_FLOAT] < 0.0))
		{
			if(ent & box_stuck[BOX_INDEX]) ++box_stuck[BOX_STUCK_TIMES]
			
			box_stuck[BOX_INDEX] |= ent
			
			if(box_stuck[BOX_STUCK_TIMES] > UNSTUCK)
			{
				box_stuck[BOX_STUCK_TIMES] = 0
				box_stuck[BLOCK_BUG] = 1
			}	
		}
		
		if(box_stuck[BLOCK_BUG])
		{
			box_stuck[BLOCK_BUG] = 0
			box_stuck[BOX_INDEX] ^= ent
			
			pev(ent, pev_origin, floats[ORIGIN])

			floats[ORIGIN][Z_AXIS_FLOAT] += 0.1
			
			set_pev(ent, pev_origin, floats[ORIGIN])
			
			floats[VELOCITY][X_AXIS_FLOAT] = 0.0 
			floats[VELOCITY][Y_AXIS_FLOAT] = 0.0
			floats[VELOCITY][Z_AXIS_FLOAT] = -GRAVITY * PUNCH_POWER
		
			set_pev(ent, pev_velocity, floats[VELOCITY])
			
			return
		}
		
#if defined SOUNDS_ON		
		emit_sound_func(ent, SOUND_TOUCH, 1)
#endif		
		pev(ent, pev_angles, floats[ANGLES])
		angle_vector(floats[ANGLES], ANGLEVECTOR_FORWARD, floats[VECTOR])

		xs_vec_cross(floats[VECTOR], floats[UP], floats[RIGHT])
		xs_vec_cross(floats[UP], floats[RIGHT], floats[FWD])

		vector_to_angle(floats[FWD], floats[ANGLES])
		vector_to_angle(floats[RIGHT], floats[ANGLES_2])

		floats[ANGLES][Z_AXIS_FLOAT] = -1.0 * floats[ANGLES_2][X_AXIS_FLOAT]

		set_pev(ent, pev_angles, floats[ANGLES])
		
		pev(ent, pev_avelocity, floats[ANGLES])
		xs_vec_mul_scalar(floats[ANGLES], ANGLES_REGRESS, floats[ANGLES])
		
		set_a_velocity(ent, floats[ANGLES])
	}
}

public ham_take_damage_pre(ent, inflictor, idattacker, Float:damage, damagebits)
{
	if(check_valid(ent))
	{
		if(get_pcvar_num(g_cvars[DAMAGE]))
		{
			static Float:ent_o[GLOBAL_COORDS_FLOAT], Float:inflictor_o[GLOBAL_COORDS_FLOAT], Float:temp[GLOBAL_COORDS_FLOAT], multiple
#if defined TRAILS_ON	
			if(get_pcvar_num(g_cvars[TRAIL]) & 2) ent_trail(ent)
#endif	
			pev(ent, pev_origin, ent_o)
			pev(inflictor, pev_origin, inflictor_o)
	
			xs_vec_sub(ent_o, inflictor_o, temp)
	
			multiple = 256
	
			if(damagebits & ~DMG_BULLET)
			{
#if !defined Half_Life	
				damage /= 0.33
				multiple *= 32
#endif
#if defined Half_Life	
				damage /= 0.48
				multiple *= 24
#endif	
			}
	
			xs_vec_mul_scalar(temp, (damage * GRAVITY) / ((get_distance_f(inflictor_o, ent_o) / 32) / REDUCE), temp)
			set_pev(ent, pev_velocity, temp)
	
			temp[X_AXIS_FLOAT] *= random_float(damage, damage * GRAVITY) / multiple
			temp[Y_AXIS_FLOAT] = random_float(-damage, damage) * 16
			temp[Z_AXIS_FLOAT] *= random_float(damage, damage * GRAVITY) / multiple
	
			set_a_velocity(ent, temp)
		}
	
		SetHamParamFloat(4, 0.0)
	}
}

#if defined DEBUG_ON
print_cmd(mode, class[])
{
	new msg[128]
	static class_num
	
	if(mode) formatex(msg, charsmax(msg), "%s%s%s%s%s", "^n********^nAMXMODX: hl_weapon_physics:", "`", class, "`", "- BLOCKED!^n********")
	else if(!mode) formatex(msg, charsmax(msg), "%s%s%s%s%s%d%s%s", "^n********^nAMXMODX: hl_weapon_physics:", "`", class, "`", "(", ++class_num, ")", "^n********")
	
	server_print(msg)
}
#endif

public fm_set_model_post(ent, model[])
{
	if(ent > g_cvars[MAX_PLAYERS] && check_valid(ent) && 1 << check_pev(ent, pev_movetype) & 1 << MOVETYPE_TOSS)
	{
		static class[32], output[12]
		
		pev(ent, pev_classname, class, charsmax(class))	
		TrieGetString(g_trie_string, class, output, charsmax(output))
		
		if(output[0])
		{
#if defined DEBUG_ON	
			print_cmd(1, class)
#endif				
			return
		}
		
		new registered, trie_key
		trie_key = TrieKeyExists(g_trie_string, class)
		
		if(!trie_key)
		{		
#if defined DEBUG_ON
			client_print(0, print_chat, "REGISTERED: %s", class)
			print_cmd(0, class)	
#endif				
			TrieSetString(g_trie_string, class, "")
			RegisterHam(Ham_TakeDamage, class, "ham_take_damage_pre")
			RegisterHam(Ham_Touch, class, "ham_touch_post", 1)
			
			registered = 1	
		}
		
		if(registered || trie_key)
		{
#if defined DEBUG_ON			
			client_print(0, print_chat, "SET_PARAMS: %s", class)
#endif						
			set_pev(ent, pev_health, 111.0)
			set_pev(ent, pev_takedamage, DAMAGE_YES)
			set_pev(ent, pev_movetype, MOVETYPE_BOUNCE)
			set_pev(ent, pev_gravity, GRAVITY)		
#if defined TRAILS_ON		
			if(get_pcvar_num(g_cvars[TRAIL]) & 1) ent_trail(ent)
#endif
			new Float:rotating[GLOBAL_COORDS_FLOAT]
#if !defined Half_Life			
			rotating[X_AXIS_FLOAT] = random_float(-256.0, 256.0)
			rotating[Y_AXIS_FLOAT] = random(2) ? 256.0 : -256.0
			rotating[Z_AXIS_FLOAT] = random_float(-256.0, 256.0)
#endif
#if defined Half_Life			
			rotating[X_AXIS_FLOAT] = random_float(-256.0, 256.0)
			rotating[Y_AXIS_FLOAT] = random(2) ? 256.0 : -256.0
			rotating[Z_AXIS_FLOAT] = random_float(-256.0, 256.0)
#endif
			set_a_velocity(ent, rotating)
		
#if defined WEAPON_THROWING_ON || defined RENDERING_ON
			new owner = check_pev(ent, pev_owner), player = 1
			
			if(!(0 < owner <= g_cvars[MAX_PLAYERS])) player = 0
#if defined WEAPON_THROWING_ON && !defined RENDERING_ON
			else if(player && is_user_alive(owner) && get_pcvar_num(g_cvars[THROWING]))
#endif			
#if defined WEAPON_THROWING_ON && defined RENDERING_ON			
			else if(is_user_alive(owner) && get_pcvar_num(g_cvars[THROWING]))
#endif			
			{		
				new Float:aim[GLOBAL_COORDS_FLOAT], Float:throwing_power
				
				switch(get_user_weapon(owner))
				{				
#if !defined Half_Life				
					case CSW_USP, CSW_P228, CSW_ELITE, CSW_FIVESEVEN, CSW_GLOCK18, CSW_DEAGLE: 	throwing_power = 1.0
					case CSW_TMP, CSW_MAC10: 							throwing_power = 0.9
					case CSW_UMP45, CSW_MP5NAVY, CSW_P90, CSW_C4: 					throwing_power = 0.75
					case CSW_M3, CSW_XM1014: 							throwing_power = 0.6
					case CSW_GALIL, CSW_AK47, CSW_SCOUT, CSW_FAMAS, CSW_AUG, CSW_M4A1, CSW_SG552: 	throwing_power = 0.45 
					case CSW_G3SG1, CSW_SG550, CSW_AWP: 						throwing_power = 0.3
					case CSW_M249: 									throwing_power = 0.15
#endif
#if defined Half_Life	
					case HLW_GLOCK: 						throwing_power = 1.0
					case HLW_PYTHON: 						throwing_power = 0.9
					case HLW_HANDGRENADE, HLW_SATCHEL, HLW_SNARK, HLW_TRIPMINE:	throwing_power = 0.75
					case HLW_MP5, HLW_SHOTGUN: 					throwing_power = 0.55
					case HLW_EGON, HLW_GAUSS, HLW_CROSSBOW, HLW_HORNETGUN: 		throwing_power = 0.35
					case HLW_RPG: 							throwing_power = 0.15 				
#endif
					default: return // throwing_power = 0.5
				}
				
				velocity_by_aim(owner, 1, aim)
				
				if(!(check_pev(owner, pev_flags) & FL_ONGROUND)) throwing_power *= 1.33
				
				xs_vec_mul_scalar(aim, pev(owner, pev_button) & PRESS_BUTTON ? throwing_power * random_num(128, 256) : throwing_power * 64, aim)	
				set_pev(ent, pev_basevelocity, aim)			
			}
#if defined RENDERING_ON			
			new cvar = get_pcvar_num(g_cvars[RENDERING])
		
			if((cvar & 1 && player) || (cvar & 2 && !player) || (1 << cvar & (1 << 3)))
			{
				fm_set_rendering(ent, kRenderFxGlowShell, random(256), random(256), random(256), kRenderNormal, 16)	
			}	
#endif	
#endif		
		}	
	}
}
