#include <amxmodx>
#include <hamsandwich>
#include <fakemeta>

#define GetWeaponClip(%0)	get_pdata_int(get_pdata_cbase(%0, 373), 51, 4)
#define GetUserWeapon(%0)	get_pdata_int(get_pdata_cbase(%0, 373), 43, 4)
#define GetMaxPlayers()		get_maxplayers()

static g_iPlayerClip[33][30];
static bool:g_bDamage[33][33];

new g_SyncShotHud;

public plugin_init()
{
	register_plugin("One & Air & Jump Shot", "0.1", "fl0wer")

	register_event("HLTV", "EventNewRound", "a", "1=0", "2=0")

	RegisterHam(Ham_TakeDamage, "player", "PlayerTakeDamage")
	RegisterHam(Ham_TakeDamage, "player", "PlayerTakeDamagePost", 1)
	RegisterHam(Ham_Killed, "player", "PlayerKilled")

	g_SyncShotHud = CreateHudSyncObj();
}

public EventNewRound()
{
	static attacker, victim;

	for(attacker = 0; attacker <= GetMaxPlayers(); attacker++)
		for(victim = 0; victim <= GetMaxPlayers(); victim++)
			g_bDamage[attacker][victim] = false;

}

public PlayerTakeDamage(victim, inflicator, attacker)
{
	if(!is_user_connected(attacker))
		return;

	if(victim == attacker)
		return;

	if(0 >= attacker <= GetMaxPlayers())
		return;

	g_iPlayerClip[attacker][GetUserWeapon(attacker)] = GetWeaponClip(attacker);
}

public PlayerKilled(victim, attacker)
{
	if(!is_user_connected(attacker))
		return;

	if(victim == attacker)
		return;

	if(0 >= attacker > GetMaxPlayers())
		return;

	new Float:vecVelocity[3], szName[32];
	pev(attacker, pev_velocity, vecVelocity)
	get_user_name(attacker, szName, charsmax(szName))

	if(vecVelocity[2] != 0.0)
	{	
		if(vecVelocity[2] > 1.0)
		{
			set_hudmessage(255, 0, 255, -1.0, 0.35, 0, 6.0, 6.0, 0.5, 0.15, -1)
			ShowSyncHudMsg(0, g_SyncShotHud, "Wow! %s made a jump shot kill!!!", szName)
		}
	
		if(vecVelocity[2] < -1.0)
		{
			set_hudmessage(255, 0, 255, -1.0, 0.35, 0, 6.0, 6.0, 0.5, 0.15, -1)
			ShowSyncHudMsg(0, g_SyncShotHud, "Wow! %s made a air shot kill!!!", szName)
		}
	}

	if(1<<GetUserWeapon(attacker) & (1<<CSW_AWP | 1<<CSW_KNIFE))
		return;

	if(g_bDamage[attacker][victim])
		return;

	if(g_iPlayerClip[attacker][GetUserWeapon(attacker)] != GetWeaponClip(attacker))
		return;

	set_hudmessage(255, 0, 255, -1.0, 0.35, 0, 6.0, 6.0, 0.5, 0.15, -1)
	ShowSyncHudMsg(0, g_SyncShotHud, "Wow! %s made a one shot kill!!!", szName)
}

public PlayerTakeDamagePost(victim, inflicator, attacker)
{
	if(!is_user_connected(attacker))
		return;

	if(victim == attacker)
		return;

	if(0 >= attacker > GetMaxPlayers())
		return;

	g_bDamage[attacker][victim] = true;
}