/* AttendanceAdmins v1.0 */

#include <amxmodx>
#include <amxmisc>

#define PLUGIN "AttendanceAdmins"
#define VERSION "1.0"
#define AUTHOR "ZETA [M|E|N]"

new attendancemotd[10001],statisticsmotd[7001],motd[10000]
new path[211],attendanceini[81],attendancehtml[81],adminhtml[81]
new statisticsini[81],statisticshtml[81],text[81],regtime
new adminname[32],adminip[21],gamedate[6],gametime
new regname[32],regip[21],regdate[6],str_regtime[7]
new attendance[81],generaltime,statstime,line,num
new input[1001],addinput[211],addmotd[210],param[40]

public plugin_init() {
	register_plugin("AttendanceAdmins","1.0","ZETA [M|E|N]")
	register_clcmd("say /attendance","func_say_attendance",ADMIN_BAN,"")
	register_clcmd("attendance","func_console_attendance",ADMIN_BAN,"")
	register_cvar("aa_path","")
}

public plugin_cfg() {
	get_configsdir(attendanceini,81) 
	get_configsdir(attendancehtml,81)
	get_configsdir(statisticsini,81)
	get_configsdir(statisticshtml,81)
	get_configsdir(adminhtml,81)
	format(attendanceini,80,"%s/AttendanceAdmins/Attendance.ini",attendanceini)
	format(attendancehtml,80,"%s/AttendanceAdmins/Attendance.html",attendancehtml)
	format(statisticsini,80,"%s/AttendanceAdmins/Statistics.ini",statisticsini)
	format(statisticshtml,80,"%s/AttendanceAdmins/Statistics.html",statisticshtml)
	format(adminhtml,80,"%s/AttendanceAdmins/admin.html",adminhtml)
}

public client_disconnect(id) {
	if(is_user_admin(id)) {
		get_user_name(id,adminname,sizeof(adminname))
		get_user_ip(id,adminip,sizeof(adminip),1)
		gametime=get_user_time(id,1)/60
		get_time("%d.%m",gamedate,5)
		
		func_attendance(id)
		func_statistics(id)
	}
}

public func_attendance(id) {
	for(line=0;read_file(attendanceini,line,text,81,num);line++) {
		if(num>0&&text[0]!=';') {
			parse(text,regdate,5,regname,sizeof(regname),regip,sizeof(regip),str_regtime,6)
			if(equali(gamedate,regdate)&&(equali(adminname,regname)||equali(adminip,regip))) {
				regtime=str_to_num(str_regtime);gametime+=regtime
					
				format(attendance,80,"^"%s^" ^"%s^" ^"%s^" ^"%d^"",gamedate,adminname,adminip,gametime)
				write_file(attendanceini,attendance,line)
				return PLUGIN_HANDLED
			}
		}
	}
	format(attendance,80,"^"%s^" ^"%s^" ^"%s^" ^"%d^"",gamedate,adminname,adminip,gametime)
	write_file(attendanceini,attendance,-1)
	return PLUGIN_HANDLED
}

public func_statistics(id) {
	for(line=0;read_file(statisticsini,line,text,81,num);line++) {
		if(num>0&&text[0]!=';') {
			parse(text,regname,sizeof(regname),regip,sizeof(regip),str_regtime,6)
			if(equali(adminname,regname)||equali(adminip,regip)) {
				regtime=str_to_num(str_regtime);statstime+=regtime
				
				format(attendance,80,"^"%s^" ^"%s^" ^"%d^"",adminname,adminip,gametime)
				write_file(statisticsini,attendance,line)
				return PLUGIN_HANDLED
			}
		}
	}
	format(attendance,80,"^"%s^" ^"%s^" ^"%d^"",adminname,adminip,gametime)
	write_file(statisticsini,attendance,-1)
	return PLUGIN_HANDLED
}

public func_say_attendance(id) {
	get_cvar_string("aa_path",path,210)
	
	format(input,1000,"<html><body bgcolor=^"#000000^" text=^"#FFB000^"><center><img src=^"%s/AttendanceAdmins.jpg^" width=^"236^" height=^"80^"><br>",path)
	format(addinput,210,"<a href=^"%s/Attendance.html^" style=^"color:#FFFFFF;text-decoration:none^">[ ]</a>&nbsp;&nbsp;&nbsp;",path)
	add(input,1000,addinput)
	format(addinput,210,"<a href=^"%s/Statistics.html^" style=^"color:#FFFFFF;text-decoration:none^">[]</a></center>",path)
	add(input,1000,addinput)
	
	delete_file(attendancehtml)
	format(attendancemotd,10000,"<html><body bgcolor=^"#000000^" text=^"#FFB000^"><center><img src=^"%s/AttendanceAdmins.jpg^" width=^"236^" height=^"80^"><br>",path)
	format(addmotd,210,"<a href=^"%s/Attendance.html^" style=^"color:#FFFFFF;text-decoration:none^">[ ]</a>&nbsp;&nbsp;&nbsp;",path)
	add(attendancemotd,10000,addmotd)
	format(addmotd,210,"<a href=^"%s/Statistics.html^" style=^"color:#FFFFFF;text-decoration:none^">[]</a></center><br>",path)
	add(attendancemotd,10000,addmotd)
	format(addmotd,210,"<table align=center width=550 border=1 cellpadding=0 cellspacing=0><tr><td width=50>&nbsp;</td><td width=200>&nbsp;</td><td width=150>&nbsp;IP</td><td width=150>&nbsp;  </td></tr>")
	add(attendancemotd,10000,addmotd)
	
	for(line=0;read_file(attendanceini,line,text,81,num);line++) {
		if(num>0&&text[0]!=';') {
			parse(text,regdate,5,regname,sizeof(regname),regip,sizeof(regip),str_regtime,6);regtime=str_to_num(str_regtime)
			format(addmotd,210,"<tr><td>&nbsp;%s</td><td>&nbsp;%s</td><td>&nbsp;%s</td><td>&nbsp;%d .</td></tr>",regdate,regname,regip,regtime)
			add(attendancemotd,10000,addmotd)
		}
	}
	write_file(attendancehtml,attendancemotd,-1)
	
	delete_file(statisticshtml)
	format(statisticsmotd,7000,"<html><body bgcolor=^"#000000^" text=^"#FFB000^"><center><img src=^"%s/AttendanceAdmins.jpg^" width=^"236^" height=^"80^"><br>",path)
	format(addmotd,210,"<a href=^"%s/Attendance.html^" style=^"color:#FFFFFF;text-decoration:none^">[ ]</a>&nbsp;&nbsp;&nbsp;",path)
	add(statisticsmotd,7000,addmotd)
	format(addmotd,210,"<a href=^"%s/Statistics.html^" style=^"color:#FFFFFF;text-decoration:none^">[]</a></center><br>",path)
	add(statisticsmotd,7000,addmotd)
	format(addmotd,210,"<table align=center width=550 border=1 cellpadding=0 cellspacing=0><tr><td width=200>&nbsp;</td><td width=150>&nbsp;IP</td><td width=200>&nbsp;  </td></tr>")
	add(statisticsmotd,7000,addmotd)
	
	for(line=0;read_file(statisticsini,line,text,81,num);line++) {
		if(num>0&&text[0]!=';') {
			parse(text,regname,sizeof(regname),regip,sizeof(regip),str_regtime,6);regtime=str_to_num(str_regtime)
			format(addmotd,210,"<tr><td>&nbsp;%s</td><td>&nbsp;%s</td><td>&nbsp;%d .</td></tr>",regname,regip,regtime)
			add(statisticsmotd,7000,addmotd)
		}
	}
	write_file(statisticshtml,statisticsmotd,-1)
	
	show_motd(id,input,"AttendanceAdmins")
}

public func_console_attendance(id) {
	read_argv(1,param,sizeof(param))
	get_cvar_string("aa_path",path,120)
	
	if(!equali(param,"")) {
		delete_file(adminhtml)
		generaltime=0

		format(motd,7000,"<html><body bgcolor=^"#000000^" text=^"#FFB000^"><center><img src=^"%s/AttendanceAdmins.jpg^" width=^"236^" height=^"80^"><br>",path)
		format(addmotd,210,"<a href=^"%s/Attendance.html^" style=^"color:#FFFFFF;text-decoration:none^">[ ]</a>&nbsp;&nbsp;&nbsp;",path)
		add(motd,7000,addmotd)
		format(addmotd,210,"<a href=^"%s/Statistics.html^" style=^"color:#FFFFFF;text-decoration:none^">[]</a></center><br>",path)
		add(motd,7000,addmotd)
		
		add(motd,7000,"<table align=center width=550 border=1 cellpadding=0 cellspacing=0>")
		add(motd,7000,"<tr><td width=50>&nbsp;</td><td width=200>&nbsp;</td><td width=150>&nbsp;IP</td><td width=150>&nbsp;  </td></tr>")
		
		for(line=0;read_file(attendanceini,line,text,81,num);line++) {
			if(num>0&&text[0]!=';') {
				parse(text,regdate,5,regname,sizeof(regname),regip,sizeof(regip),str_regtime,6)
				if(equali(param,regname)||equali(param,regip)) {
					regtime=str_to_num(str_regtime);generaltime+=regtime
					
					format(addmotd,120,"<tr><td>&nbsp;%s</td><td>&nbsp;%s</td><td>&nbsp;%s</td><td>&nbsp;%d .</td></tr>",regdate,regname,regip,regtime)
					add(motd,7000,addmotd)
				}
			}
		}
		add(motd,7000,"</table><br><table align=center width=550 border=1 cellpadding=0 cellspacing=0>")
		format(addmotd,120,"<tr><td width=400>&nbsp; ,   </td><td width=150>&nbsp;%d .</td></tr></table>",generaltime)
		add(motd,7000,addmotd)
		write_file(adminhtml,motd,-1)
		
		set_task(2.0,"show",id)
	}
	else {
		format(input,1000,"<html><body bgcolor=^"#000000^" text=^"#FFB000^"><center><img src=^"%s/AttendanceAdmins.jpg^" width=^"236^" height=^"80^"><br>",path)
		format(addinput,210,"<a href=^"%s/Attendance.html^" style=^"color:#FFFFFF;text-decoration:none^">[ ]</a>&nbsp;&nbsp;&nbsp;",path)
		add(input,1000,addinput)
		format(addinput,210,"<a href=^"%s/Statistics.html^" style=^"color:#FFFFFF;text-decoration:none^">[]</a></center>",path)
		add(input,1000,addinput)
		
		show_motd(id,input,"AttendanceAdmins")
	}
	return PLUGIN_HANDLED
}

public show(id) {
	format(input,410,"<html><body bgcolor=#000000 text=#FFB000><center><img src=^"%s/AttendanceAdmins.jpg^" width=236 height=80><br><a href=^"%s/admin.html^" style=^"color:#FFFFFF;text-decoration:none^">[   ]</a></center>",path,path)
	show_motd(id,input,"AttendanceAdmins")
}