/* 
Plugin: Simple AFK Manager
Version: 2.3
 [gm-project.net] #Staff.

Support on alliedmods.net: http://forums.alliedmods.net/showthread.php?t=110536
Support on gm-project.net: http://gm-community.net/showthread.php?t=581
*/

#include <amxmodx>
#include <fakemeta>

#define PLUGIN "Simple AFK Manager"
#define VERSION "2.3"
#define AUTHOR "[gm-project.net] #Staff"

#define PREFIX "SAM"

#define OFFSET_LAST_MOVEMENT 124

new g_maxplayers

new Float:g_spec_time[33]

new g_Reason, g_aTime, g_sTime, g_Report, g_Info
new g_Immunity, g_kickBots, g_kickHLTV, g_showMsg
new g_afkCount[2]

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	g_maxplayers = get_maxplayers()
	
	g_Reason = register_cvar("afk_kick_reason", "AFK")
	g_aTime = register_cvar("afk_time", "60.0")
	g_sTime = register_cvar("afk_spec_time", "180.0")
	g_Report = register_cvar("afk_report", "2")
	g_showMsg = register_cvar("afk_showmsg", "1")
	g_Info = register_cvar("afk_info_time", "20.0")
	g_Immunity = register_cvar("afk_immunity_flag", "b")
	g_kickBots = register_cvar("afk_kick_bots", "0")
	g_kickHLTV = register_cvar("afk_kick_hltv", "0")

	register_dictionary("sam.txt")

	register_cvar("sam_version", VERSION, FCVAR_SERVER | FCVAR_SPONLY)
	set_task(10.0, "checkAFK", _, _, _, "b")
	register_logevent("RoundStart", 2, "1=Round_Start")
}

public client_putinserver(id) {
	g_spec_time[id] = 0.0
}

public RoundStart() {
	new ShowMsg
	ShowMsg = get_pcvar_num(g_showMsg)

	if (ShowMsg) {
		client_print(0, print_chat, "[%s] %L", PREFIX, LANG_PLAYER, "AFK_MSG", g_afkCount[1], g_afkCount[0])
	}
}

public checkAFK() {
	new Float:afk_time = get_pcvar_float(g_aTime)
	new Float:afk_spec_time = get_pcvar_float(g_sTime)
	new Float:afk_info_time = get_pcvar_float(g_Info)
	new i, Float:cur_time, team, Float:lastActivity
	g_afkCount[0] = g_afkCount[1] = 0
	new strFlag[20]
	get_pcvar_string(g_Immunity, strFlag, 19)
	new flag = read_flags(strFlag)
	cur_time = get_gametime()
	if (afk_time)
		afk_time = cur_time - afk_time
	if (afk_spec_time)
		afk_spec_time = cur_time - afk_spec_time
	if (afk_info_time)
		afk_info_time = cur_time - afk_info_time
	
	new kick_bot = get_pcvar_num(g_kickBots)
	new kick_hltv = get_pcvar_num(g_kickHLTV)
	
	for (i = 1; i <= g_maxplayers; i++)
	{
		if (!is_user_connected(i) || (get_user_flags(i)&flag) 
		|| (is_user_bot(i) && kick_bot)
		|| (is_user_hltv(i) && kick_hltv))
				continue
				
		team = get_user_team(i)
		if (1 <= team <= 2)
       		{
           		if (!is_user_alive(i) || !afk_time)
            	 		continue
			g_spec_time[i] = 0.0
			lastActivity = get_pdata_float(i, OFFSET_LAST_MOVEMENT)
			if (lastActivity < afk_time)
				kickAFK(i)
			else
			{
				if (lastActivity < afk_info_time) {
					client_print(i, print_chat, "[%s] %L", PREFIX, LANG_PLAYER, "AFK_WARN", floatround(afk_info_time - afk_time))
					g_afkCount[team - 1] ++
				}
			}
		}
		else
		{
			if (!afk_spec_time)
				continue
			if (!g_spec_time[i])
				g_spec_time[i] = cur_time
			else
			if (g_spec_time[i] < afk_spec_time)
				kickAFK(i)
		}
		
	}
}

public kickAFK(id) {
	new name[32], reason[128], report
	
	get_user_name(id, name, 31)
	get_pcvar_string(g_Reason, reason, 127)
	report = get_pcvar_num(g_Report)
	
	message_begin( MSG_ONE, SVC_DISCONNECT, _, id )
	write_string( reason )
	message_end( )
	server_exec()
	
	if (report == 2)
		client_print(0, print_chat, "[%s] %L", PREFIX, LANG_PLAYER, "AFK_KICK", name)
	else
	if (report == 1) {
		for (report = 1; report <= g_maxplayers; report++)
		{
			if (get_user_flags(report) & ADMIN_CHAT)
				client_print(report, print_chat, "[%s] %L", PREFIX, LANG_PLAYER, "AFK_KICK", name)
		}
	}
	
}
/* Fedcomp is bot */